/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.tools.xml.webapp.v23;

import org.exoplatform.tools.xml.webapp.v23.WebAppModifyTask;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class WebAppServletMappingModifyTask
extends WebAppModifyTask {
    public static final String CLASS_VERSION = "$Id: WebAppServletMappingModifyTask.java,v 1.1 2004/04/19 03:45:49 hatimk Exp $";
    private String mServletName;
    private String mURLPattern;
    private XPath mServletNameXPath;
    private XPath mURLPatternXPath;

    public WebAppServletMappingModifyTask(String pServletName, String pURLPattern) {
        this.mServletName = pServletName;
        this.mURLPattern = pURLPattern;
    }

    protected int detect(Document pDoc) throws JaxenException {
        Node servletNode;
        if (this.mURLPatternXPath == null) {
            this.mURLPatternXPath = new DOMXPath("/web-app/servlet-mapping[url-pattern=\"" + this.mURLPattern + "\"]");
        }
        if (this.mServletNameXPath == null) {
            this.mServletNameXPath = new DOMXPath("servlet-name=\"" + this.mServletName + "\"");
        }
        if ((servletNode = (Node)this.mURLPatternXPath.selectSingleNode((Object)pDoc)) != null) {
            if (this.mServletNameXPath.booleanValueOf((Object)servletNode)) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    protected void insert(Document pDoc) throws JaxenException {
        Node parent = this.getWebAppNode(pDoc);
        this.insertElement(parent, this.createServletMappingElement(pDoc), WEBAPP_CHILD_ELEMENTS);
    }

    protected void replace(Document pDoc) throws JaxenException {
        DOMXPath servletNameXPath = new DOMXPath("servlet-name");
        Node parent = (Node)this.mURLPatternXPath.selectSingleNode((Object)pDoc);
        Node servletNameNode = (Node)servletNameXPath.selectSingleNode((Object)parent);
        if (servletNameNode == null) {
            this.insertElement(parent, this.createServletNameElement(pDoc), SERVLETMAPPING_CHILD_ELEMENTS);
        } else {
            parent.replaceChild(this.createServletNameElement(pDoc), servletNameNode);
        }
    }

    private Node createServletMappingElement(Document pDoc) {
        Node urlPattern = this.createURLPatternElement(pDoc);
        Node servletName = this.createServletNameElement(pDoc);
        Element servletMapping = pDoc.createElement("servlet-mapping");
        servletMapping.appendChild(servletName);
        servletMapping.appendChild(urlPattern);
        return servletMapping;
    }

    private Node createURLPatternElement(Document pDoc) {
        Text urlPatternText = pDoc.createTextNode(this.mURLPattern);
        Element urlPattern = pDoc.createElement("url-pattern");
        urlPattern.appendChild(urlPatternText);
        return urlPattern;
    }

    private Node createServletNameElement(Document pDoc) {
        Text servletNameText = pDoc.createTextNode(this.mServletName);
        Element servletName = pDoc.createElement("servlet-name");
        servletName.appendChild(servletNameText);
        return servletName;
    }
}

