/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jarsigner;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-jarsigner-plugin:1.2", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Jarsigner Plugin", 0);
        this.append(sb, "Signs or verifies a project artifact and attachments using jarsigner.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "jarsigner:help", 0);
            this.append(sb, "Display help information on maven-jarsigner-plugin.\nCall\n\u00a0\u00a0mvn\u00a0jarsigner:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "sign".equals(this.goal)) {
            this.append(sb, "jarsigner:sign", 0);
            this.append(sb, "Signs a project artifact and attachments using jarsigner.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "alias", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "Archive to process. If set, neither the project artifact nor any attachments or archive sets are processed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "archiveDirectory", 2);
                this.append(sb, "The base directory to scan for JAR files using Ant-like inclusion/exclusion patterns.", 3);
                this.append(sb, "", 0);
                this.append(sb, "arguments", 2);
                this.append(sb, "List of additional arguments to append to the jarsigner command line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "attachments", 2);
                this.append(sb, "Deprecated. As of version 1.1 in favor of the new parameter processAttachedArtifacts.", 3);
                this.append(sb, "", 0);
                this.append(sb, "Controls processing of project attachments.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeClassifiers", 2);
                this.append(sb, "A set of artifact classifiers describing the project attachments that should not be processed. This parameter is only relevant if processAttachedArtifacts is true. If empty, no attachments are excluded.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "The Ant-like exclusion patterns used to exclude JAR files from processing. The patterns must be relative to the directory given by the parameter archiveDirectory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeClassifiers", 2);
                this.append(sb, "A set of artifact classifiers describing the project attachments that should be processed. This parameter is only relevant if processAttachedArtifacts is true. If empty, all attachments are included.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "The Ant-like inclusion patterns used to select JAR files to process. The patterns must be relative to the directory given by the parameter archiveDirectory. By default, the pattern **/*.?ar is used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "keypass", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "", 0);
                this.append(sb, "keystore", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxMemory", 2);
                this.append(sb, "The maximum memory available to the JAR signer, e.g. 256M. See -Xmx for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "processAttachedArtifacts (Default: true)", 2);
                this.append(sb, "Controls processing of project attachments. If enabled, attached artifacts that are no JAR/ZIP files will be automatically excluded from processing.", 3);
                this.append(sb, "", 0);
                this.append(sb, "processMainArtifact (Default: true)", 2);
                this.append(sb, "Controls processing of the main artifact produced by the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerArg", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerClass", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerName", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "", 0);
                this.append(sb, "removeExistingSignatures (Default: false)", 2);
                this.append(sb, "Indicates whether existing signatures should be removed from the processed JAR files prior to signing them. If enabled, the resulting JAR will appear as being signed only once.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sigfile", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Set to true to disable the plugin.", 3);
                this.append(sb, "", 0);
                this.append(sb, "storepass", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "", 0);
                this.append(sb, "storetype", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "verify".equals(this.goal)) {
            this.append(sb, "jarsigner:verify", 0);
            this.append(sb, "Checks the signatures of a project artifact and attachments using jarsigner.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "Archive to process. If set, neither the project artifact nor any attachments or archive sets are processed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "archiveDirectory", 2);
                this.append(sb, "The base directory to scan for JAR files using Ant-like inclusion/exclusion patterns.", 3);
                this.append(sb, "", 0);
                this.append(sb, "arguments", 2);
                this.append(sb, "List of additional arguments to append to the jarsigner command line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "attachments", 2);
                this.append(sb, "Deprecated. As of version 1.1 in favor of the new parameter processAttachedArtifacts.", 3);
                this.append(sb, "", 0);
                this.append(sb, "Controls processing of project attachments.", 3);
                this.append(sb, "", 0);
                this.append(sb, "certs (Default: false)", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeClassifiers", 2);
                this.append(sb, "A set of artifact classifiers describing the project attachments that should not be processed. This parameter is only relevant if processAttachedArtifacts is true. If empty, no attachments are excluded.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "The Ant-like exclusion patterns used to exclude JAR files from processing. The patterns must be relative to the directory given by the parameter archiveDirectory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeClassifiers", 2);
                this.append(sb, "A set of artifact classifiers describing the project attachments that should be processed. This parameter is only relevant if processAttachedArtifacts is true. If empty, all attachments are included.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "The Ant-like inclusion patterns used to select JAR files to process. The patterns must be relative to the directory given by the parameter archiveDirectory. By default, the pattern **/*.?ar is used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxMemory", 2);
                this.append(sb, "The maximum memory available to the JAR signer, e.g. 256M. See -Xmx for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "processAttachedArtifacts (Default: true)", 2);
                this.append(sb, "Controls processing of project attachments. If enabled, attached artifacts that are no JAR/ZIP files will be automatically excluded from processing.", 3);
                this.append(sb, "", 0);
                this.append(sb, "processMainArtifact (Default: true)", 2);
                this.append(sb, "Controls processing of the main artifact produced by the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Set to true to disable the plugin.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

