/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jdeps.consumers;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDepsConsumer
extends CommandLineUtils.StringStreamConsumer
implements StreamConsumer {
    private static final Pattern JDKINTERNALAPI = Pattern.compile("\\s+->\\s([a-z\\.]+)\\s+(JDK internal API .+)");
    private Map<String, String> offendingPackages = new HashMap<String, String>();
    private static final Pattern PROFILE = Pattern.compile("\\s+->\\s([a-z\\.]+)\\s+(\\S+)");
    private Map<String, String> profiles = new HashMap<String, String>();

    public void consumeLine(String line) {
        super.consumeLine(line);
        Matcher matcher = JDKINTERNALAPI.matcher(line);
        if (matcher.matches()) {
            this.offendingPackages.put(matcher.group(1), matcher.group(2));
            return;
        }
        matcher = PROFILE.matcher(line);
        if (matcher.matches()) {
            this.profiles.put(matcher.group(1), matcher.group(2));
            return;
        }
    }

    public Map<String, String> getOffendingPackages() {
        return this.offendingPackages;
    }

    public Map<String, String> getProfiles() {
        return this.profiles;
    }
}

