/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.plexus.util.StringUtils;

public class IssueTrackingReport
extends AbstractMavenReport {
    private String outputDirectory;
    private SiteRenderer siteRenderer;
    private MavenProject project;
    static /* synthetic */ Class class$org$apache$maven$report$projectinfo$IssueTrackingReport;

    public String getName(Locale locale) {
        return IssueTrackingReport.getBundle(locale).getString("report.issuetracking.name");
    }

    public String getCategoryName() {
        return "Project Info";
    }

    public String getDescription(Locale locale) {
        return IssueTrackingReport.getBundle(locale).getString("report.issuetracking.description");
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public void executeReport(Locale locale) {
        IssueTrackingRenderer r = new IssueTrackingRenderer(this.getSink(), this.getProject().getModel(), locale);
        r.render();
    }

    public String getOutputName() {
        return "issue-tracking";
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("project-info-report", locale, (class$org$apache$maven$report$projectinfo$IssueTrackingReport == null ? (class$org$apache$maven$report$projectinfo$IssueTrackingReport = IssueTrackingReport.class$("org.apache.maven.report.projectinfo.IssueTrackingReport")) : class$org$apache$maven$report$projectinfo$IssueTrackingReport).getClassLoader());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class IssueTrackingRenderer
    extends AbstractMavenReportRenderer {
        private Model model;
        private Locale locale;

        public IssueTrackingRenderer(Sink sink, Model model, Locale locale) {
            super(sink);
            this.model = model;
            this.locale = locale;
        }

        public String getTitle() {
            return IssueTrackingReport.getBundle(this.locale).getString("report.issuetracking.title");
        }

        public void renderBody() {
            IssueManagement issueManagement = this.model.getIssueManagement();
            if (issueManagement == null) {
                this.startSection(this.getTitle());
                this.paragraph(IssueTrackingReport.getBundle(this.locale).getString("report.issuetracking.noissueManagement"));
                this.endSection();
                return;
            }
            String system = issueManagement.getSystem();
            String url = issueManagement.getUrl();
            this.startSection(IssueTrackingReport.getBundle(this.locale).getString("report.issuetracking.overview.title"));
            if (this.isIssueManagementSystem(system, "jira")) {
                this.linkPatternedText(IssueTrackingReport.getBundle(this.locale).getString("report.issuetracking.jira.intro"));
            } else if (this.isIssueManagementSystem(system, "bugzilla")) {
                this.linkPatternedText(IssueTrackingReport.getBundle(this.locale).getString("report.issuetracking.bugzilla.intro"));
            } else if (this.isIssueManagementSystem(system, "scarab")) {
                this.linkPatternedText(IssueTrackingReport.getBundle(this.locale).getString("report.issuetracking.scarab.intro"));
            } else {
                this.paragraph(IssueTrackingReport.getBundle(this.locale).getString("report.issuetracking.general.intro"));
            }
            this.endSection();
            this.startSection(this.getTitle());
            this.paragraph(IssueTrackingReport.getBundle(this.locale).getString("report.issuetracking.intro"));
            this.verbatimLink(url, url);
            this.endSection();
        }

        private boolean isIssueManagementSystem(String system, String im) {
            if (StringUtils.isEmpty((String)system)) {
                return false;
            }
            if (StringUtils.isEmpty((String)im)) {
                return false;
            }
            return system.toLowerCase().startsWith(im.toLowerCase());
        }
    }
}

