/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.site.decoration.Body;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.RenderingContext;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.doxia.tools.SiteToolException;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProjectInfoReport
extends AbstractMavenReport {
    @Component
    protected SiteTool siteTool;
    @Component
    protected Renderer siteRenderer;
    @Component
    protected ArtifactResolver resolver;
    @Component
    protected ArtifactFactory factory;
    @Component
    private I18N i18n;
    @Component
    protected MavenProjectBuilder mavenProjectBuilder;
    @Parameter(property="project.reporting.outputDirectory", required=true)
    protected File outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="localRepository", required=true, readonly=true)
    protected ArtifactRepository localRepository;
    @Parameter(property="project.remoteArtifactRepositories")
    protected List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    protected Settings settings;
    @Parameter(defaultValue="${project.basedir}/src/site/custom/project-info-reports.properties")
    protected String customBundle;
    @Parameter(property="mpir.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="true")
    protected boolean skipEmptyReport;

    public boolean canGenerateReport() {
        return !this.skip;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException {
        if (!this.canGenerateReport()) {
            return;
        }
        OutputStreamWriter writer = null;
        try {
            String filename = this.getOutputName() + ".html";
            DecorationModel model = new DecorationModel();
            model.setBody(new Body());
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("outputEncoding", "UTF-8");
            attributes.put("project", (String)this.project);
            Locale locale = Locale.getDefault();
            Artifact defaultSkin = this.siteTool.getDefaultSkinArtifact(this.localRepository, this.project.getRemoteArtifactRepositories());
            SiteRenderingContext siteContext = this.siteRenderer.createContextForSkin(defaultSkin.getFile(), attributes, model, this.getName(locale), locale);
            RenderingContext context = new RenderingContext(this.outputDirectory, filename);
            SiteRendererSink sink = new SiteRendererSink(context);
            this.generate((Sink)sink, null, locale);
            this.outputDirectory.mkdirs();
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.outputDirectory, filename)), "UTF-8");
            this.siteRenderer.generateDocument((Writer)writer, sink, siteContext);
            this.siteRenderer.copyResources(siteContext, new File(this.project.getBasedir(), "src/site/resources"), this.outputDirectory);
        }
        catch (RendererException e) {
            try {
                throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)((Object)e));
                catch (IOException e2) {
                    throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)e2);
                }
                catch (SiteToolException e3) {
                    throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)((Object)e3));
                }
                catch (MavenReportException e4) {
                    throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)((Object)e4));
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }

    public String getCategoryName() {
        return "Project Info";
    }

    protected boolean isEmpty(Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    public File getReportOutputDirectory() {
        return this.outputDirectory;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.outputDirectory = reportOutputDirectory;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Plugin getPlugin(String pluginId) {
        if (this.getProject().getBuild() == null || this.getProject().getBuild().getPluginsAsMap() == null) {
            return null;
        }
        Plugin plugin = (Plugin)this.getProject().getBuild().getPluginsAsMap().get(pluginId);
        if (plugin == null && this.getProject().getBuild().getPluginManagement() != null && this.getProject().getBuild().getPluginManagement().getPluginsAsMap() != null) {
            plugin = (Plugin)this.getProject().getBuild().getPluginManagement().getPluginsAsMap().get(pluginId);
        }
        return plugin;
    }

    protected String getPluginParameter(String pluginId, String param) {
        Xpp3Dom xpp3Dom;
        Plugin plugin = this.getPlugin(pluginId);
        if (plugin != null && (xpp3Dom = (Xpp3Dom)plugin.getConfiguration()) != null && xpp3Dom.getChild(param) != null && StringUtils.isNotEmpty((String)xpp3Dom.getChild(param).getValue())) {
            return xpp3Dom.getChild(param).getValue();
        }
        return null;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String getI18nString(Locale locale, String key) {
        return this.getI18N(locale).getString("project-info-reports", locale, "report." + this.getI18Nsection() + '.' + key);
    }

    protected I18N getI18N(Locale locale) {
        File customBundleFile;
        if (this.customBundle != null && (customBundleFile = new File(this.customBundle)).isFile() && customBundleFile.getName().endsWith(".properties")) {
            if (!this.i18n.getClass().isAssignableFrom(CustomI18N.class)) {
                this.i18n = new CustomI18N(this.project, this.settings, customBundleFile, locale, this.i18n);
            } else if (!this.i18n.getDefaultLanguage().equals(locale.getLanguage())) {
                this.i18n = new CustomI18N(this.project, this.settings, customBundleFile, locale, this.i18n);
            }
        }
        return this.i18n;
    }

    protected abstract String getI18Nsection();

    public String getName(Locale locale) {
        return this.getI18nString(locale, "name");
    }

    public String getDescription(Locale locale) {
        return this.getI18nString(locale, "description");
    }

    private static class CustomI18N
    implements I18N {
        private final MavenProject project;
        private final Settings settings;
        private final String bundleName;
        private final Locale locale;
        private final I18N i18nOriginal;
        private ResourceBundle bundle;
        private static final Object[] NO_ARGS = new Object[0];

        public CustomI18N(MavenProject project, Settings settings, File customBundleFile, Locale locale, I18N i18nOriginal) {
            this.project = project;
            this.settings = settings;
            this.locale = locale;
            this.i18nOriginal = i18nOriginal;
            this.bundleName = customBundleFile.getName().substring(0, customBundleFile.getName().indexOf(".properties"));
            URLClassLoader classLoader = null;
            try {
                classLoader = new URLClassLoader(new URL[]{customBundleFile.getParentFile().toURI().toURL()});
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            this.bundle = ResourceBundle.getBundle(this.bundleName, locale, classLoader);
            if (!this.bundle.getLocale().getLanguage().equals(locale.getLanguage())) {
                this.bundle = ResourceBundle.getBundle(this.bundleName, Locale.getDefault(), classLoader);
            }
        }

        public String getDefaultLanguage() {
            return this.locale.getLanguage();
        }

        public String getDefaultCountry() {
            return this.locale.getCountry();
        }

        public String getDefaultBundleName() {
            return this.bundleName;
        }

        public String[] getBundleNames() {
            return new String[]{this.bundleName};
        }

        public ResourceBundle getBundle() {
            return this.bundle;
        }

        public ResourceBundle getBundle(String bundleName) {
            return this.bundle;
        }

        public ResourceBundle getBundle(String bundleName, String languageHeader) {
            return this.bundle;
        }

        public ResourceBundle getBundle(String bundleName, Locale locale) {
            return this.bundle;
        }

        public Locale getLocale(String languageHeader) {
            return new Locale(languageHeader);
        }

        public String getString(String key) {
            return this.getString(this.bundleName, this.locale, key);
        }

        public String getString(String key, Locale locale) {
            return this.getString(this.bundleName, locale, key);
        }

        public String getString(String bundleName, Locale locale, String key) {
            ResourceBundle rb;
            String value;
            if (locale == null) {
                locale = this.getLocale(null);
            }
            if ((value = this.getStringOrNull(rb = this.getBundle(bundleName, locale), key)) == null) {
                value = this.i18nOriginal.getString(bundleName, locale, key);
            }
            if (!value.contains("${")) {
                return value;
            }
            RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
            try {
                interpolator.addValueSource((ValueSource)new EnvarBasedValueSource());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(System.getProperties()));
            interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(this.project.getProperties()));
            interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("project", (Object)this.project));
            interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("pom", (Object)this.project));
            interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("settings", (Object)this.settings));
            try {
                value = interpolator.interpolate(value);
            }
            catch (InterpolationException interpolationException) {
                // empty catch block
            }
            return value;
        }

        public String format(String key, Object arg1) {
            return this.format(this.bundleName, this.locale, key, new Object[]{arg1});
        }

        public String format(String key, Object arg1, Object arg2) {
            return this.format(this.bundleName, this.locale, key, new Object[]{arg1, arg2});
        }

        public String format(String bundleName, Locale locale, String key, Object arg1) {
            return this.format(bundleName, locale, key, new Object[]{arg1});
        }

        public String format(String bundleName, Locale locale, String key, Object arg1, Object arg2) {
            return this.format(bundleName, locale, key, new Object[]{arg1, arg2});
        }

        public String format(String bundleName, Locale locale, String key, Object[] args) {
            if (locale == null) {
                locale = this.getLocale(null);
            }
            String value = this.getString(bundleName, locale, key);
            if (args == null) {
                args = NO_ARGS;
            }
            MessageFormat messageFormat = new MessageFormat("");
            messageFormat.setLocale(locale);
            messageFormat.applyPattern(value);
            return messageFormat.format(args);
        }

        private String getStringOrNull(ResourceBundle rb, String key) {
            if (rb != null) {
                try {
                    return rb.getString(key);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

