/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.Locale;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.report.projectinfo.ModulesReport;
import org.codehaus.plexus.i18n.I18N;

@Mojo(name="index")
public class IndexReport
extends AbstractProjectInfoReport {
    public String getName(Locale locale) {
        return this.getI18nString(locale, "title");
    }

    public String getDescription(Locale locale) {
        if (this.project.getDescription() == null) {
            return this.getI18nString(locale, "nodescription");
        }
        String desc = this.project.getDescription();
        return desc;
    }

    public void executeReport(Locale locale) {
        ProjectIndexRenderer r = new ProjectIndexRenderer(this.project, this.mavenProjectBuilder, this.localRepository, this.getName(locale), this.getDescription(locale), this.getSink(), this.getI18N(locale), locale, this.siteTool);
        r.render();
    }

    public String getOutputName() {
        return "index";
    }

    protected String getI18Nsection() {
        return "index";
    }

    private static class ProjectIndexRenderer
    extends ModulesReport.ModulesRenderer {
        private final String title;
        private final String description;
        private boolean modules = false;

        ProjectIndexRenderer(MavenProject project, MavenProjectBuilder mavenProjectBuilder, ArtifactRepository localRepository, String title, String description, Sink sink, I18N i18n, Locale locale, SiteTool siteTool) {
            super(sink, project, mavenProjectBuilder, localRepository, i18n, locale, siteTool);
            this.title = title;
            this.description = description;
        }

        public String getTitle() {
            return this.modules ? super.getTitle() : this.title;
        }

        public void renderBody() {
            this.startSection(this.title.trim() + " " + this.project.getName());
            this.paragraph(this.description);
            if (!this.project.getModel().getModules().isEmpty()) {
                this.modules = true;
                super.renderBody();
            }
            this.endSection();
        }
    }
}

