package org.apache.maven.plugin.resources.remote;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-remote-resources-plugin.<br/> Call <pre>  mvn remote-resources:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Tue Jun 14 19:33:42 CEST 2011
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.7)
 * @goal help
 * @requiresProject false
 * @threadSafe
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.apache.maven.plugins:maven-remote-resources-plugin:1.2.1", 0 );
        append( sb, "", 0 );

        append( sb, "Maven Remote Resources Plugin", 0 );
        append( sb, "Process resources packaged in JARs that have been deployed to a remote repository. The primary use case being satisfied is the consistent inclusion of common resources in a large set of projects. Maven projects at Apache use this plug-in to satisfy licensing requirements at Apache where each project must include license and notice files for each release.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 3 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "bundle".equals( goal ) )
        {
            append( sb, "remote-resources:bundle", 0 );
            append( sb, "Bundle up resources that should be considered as a remote-resource.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A list of files to exclude. Can contain ant-style wildcards and double wildcards.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A list of files to include. Can contain ant-style wildcards and double wildcards. The default includes are **/*.txt **/*.vm", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The directory where you want the resource bundle manifest written to.", 3 );
                append( sb, "Expression: ${project.build.outputDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "resourcesDirectory", 2 );
                append( sb, "The directory which contains the resources you want packaged up in this resource bundle.", 3 );
                append( sb, "Expression: ${basedir}/src/main/resources", 3 );
                append( sb, "", 0 );

                append( sb, "sourceEncoding", 2 );
                append( sb, "Encoding of the bundle.", 3 );
                append( sb, "Expression: ${project.build.sourceEncoding}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "remote-resources:help", 0 );
            append( sb, "Display help information on maven-remote-resources-plugin.\nCall\n\u00a0\u00a0mvn\u00a0remote-resources:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "Expression: ${detail}", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "Expression: ${goal}", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "Expression: ${indentSize}", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "Expression: ${lineLength}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "process".equals( goal ) )
        {
            append( sb, "remote-resources:process", 0 );
            append( sb, "Pull down resourceBundles containing remote resources and process the resources contained inside. When that is done the resources are injected into the current (in-memory) Maven project, making them available to the process-resources phase.\n\nResources that end in \'.vm\' are treated as velocity templates. For those, the \'.vm\' is stripped off for the final artifact name and it\'s fed through velocity to have properties expanded, conditions processed, etc...\n\nResources that don\'t end in \'.vm\' are copied \'as is\'.\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "appendedResourcesDirectory", 2 );
                append( sb, "The directory containing extra information appended to the generated resources.", 3 );
                append( sb, "Expression: ${basedir}/src/main/appended-resources", 3 );
                append( sb, "", 0 );

                append( sb, "attached (Default: true)", 2 );
                append( sb, "Attaches the resource to the project as a resource directory", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The character encoding scheme to be applied when filtering resources.", 3 );
                append( sb, "Expression: ${encoding}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeArtifactIds", 2 );
                append( sb, "Comma separated list of Artifact names too exclude.", 3 );
                append( sb, "Expression: ${excludeArtifactIds}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeGroupIds", 2 );
                append( sb, "Comma separated list of GroupId Names to exclude.", 3 );
                append( sb, "Expression: ${excludeGroupIds}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeScope", 2 );
                append( sb, "Scope to exclude. An Empty string indicates no scopes (default).", 3 );
                append( sb, "Expression: ${excludeScope}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeTransitive (Default: false)", 2 );
                append( sb, "If we should exclude transitive dependencies", 3 );
                append( sb, "Expression: ${excludeTransitive}", 3 );
                append( sb, "", 0 );

                append( sb, "filterDelimiters", 2 );
                append( sb, "In cases where a local resource overrides one from a remote resource bundle, that resource should be filtered if the resource set specifies it. In those cases, this parameter defines the list of delimiters for filterable expressions. These delimiters are specified in the form \'beginToken*endToken\'. If no \'*\' is given, the delimiter is assumed to be the same for start and end.\n\nSo, the default filtering delimiters might be specified as:\n\n<delimiters>\n\u00a0\u00a0<delimiter>${*}</delimiter>\n\u00a0\u00a0<delimiter>@</delimiter>\n</delimiters>\n\nSince the \'@\' delimiter is the same on both ends, we don\'t need to specify \'@*@\' (though we can).\n", 3 );
                append( sb, "", 0 );

                append( sb, "includeArtifactIds", 2 );
                append( sb, "Comma separated list of Artifact names to include.", 3 );
                append( sb, "Expression: ${includeArtifactIds}", 3 );
                append( sb, "", 0 );

                append( sb, "includeGroupIds", 2 );
                append( sb, "Comma separated list of GroupIds to include.", 3 );
                append( sb, "Expression: ${includeGroupIds}", 3 );
                append( sb, "", 0 );

                append( sb, "includeProjectProperties (Default: false)", 2 );
                append( sb, "Whether to include properties defined in the project when filtering resources.", 3 );
                append( sb, "", 0 );

                append( sb, "includeScope (Default: runtime)", 2 );
                append( sb, "Scope to include. An Empty string indicates all scopes (default).", 3 );
                append( sb, "Expression: ${includeScope}", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The directory where processed resources will be placed for packaging.", 3 );
                append( sb, "Expression: ${project.build.directory}/maven-shared-archive-resources", 3 );
                append( sb, "", 0 );

                append( sb, "properties", 2 );
                append( sb, "Additional properties to be passed to velocity.\n>Several properties are automatically added:\nproject - the current MavenProject\nprojects - the list of dependency projects\nprojectTimespan - the timespan of the current project (requires inceptionYear in pom)\n\n\n>See the javadoc for MavenProject for information about the properties on the MavenProject.\n", 3 );
                append( sb, "", 0 );

                append( sb, "resourceBundles", 2 );
                append( sb, "The resource bundles that will be retrieved and processed.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "runOnlyAtExecutionRoot (Default: false)", 2 );
                append( sb, "If true, only generate resources in the directory of the root project in a multimodule build. Dependencies from all modules will be aggregated before resource-generation takes place.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Skip remote-resource processing", 3 );
                append( sb, "Expression: ${remoteresources.skip}", 3 );
                append( sb, "", 0 );

                append( sb, "supplementalModelArtifacts", 2 );
                append( sb, "List of artifacts that are added to the search path when looking for supplementalModels", 3 );
                append( sb, "", 0 );

                append( sb, "supplementalModels", 2 );
                append( sb, "Supplemental model data. Useful when processing artifacts with incomplete POM metadata.\n>By default, this Mojo looks for supplemental model data in the file \'${appendedResourcesDirectory}\nsupplemental-models.xml\'.", 3 );
                append( sb, "", 0 );

                append( sb, "useDefaultFilterDelimiters (Default: true)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
