/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.site.ReportComparator;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.siterenderer.Renderer;
import org.codehaus.plexus.siterenderer.RendererException;
import org.codehaus.plexus.siterenderer.sink.SiteRendererSink;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class SiteMojo
extends AbstractMojo {
    private static final String RESOURCE_DIR = "org/apache/maven/plugins/site";
    private static final String DEFAULT_TEMPLATE = "org/apache/maven/plugins/site/maven-site.vm";
    private File siteDirectory;
    private File generatedSiteDirectory;
    private File outputDirectory;
    private File resourcesDirectory;
    private String templateDirectory;
    private String template = "org/apache/maven/plugins/site/maven-site.vm";
    private Map attributes;
    private String locales;
    private boolean addModules;
    private String outputEncoding;
    private Renderer siteRenderer;
    private I18N i18n;
    private MavenProject project;
    private List reports;
    static /* synthetic */ Class class$org$apache$maven$plugins$site$SiteMojo;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.templateDirectory == null) {
            this.siteRenderer.setTemplateClassLoader((class$org$apache$maven$plugins$site$SiteMojo == null ? (class$org$apache$maven$plugins$site$SiteMojo = SiteMojo.class$("org.apache.maven.plugins.site.SiteMojo")) : class$org$apache$maven$plugins$site$SiteMojo).getClassLoader());
        } else {
            try {
                URL templateDirectoryUrl = new URL(this.templateDirectory);
                URL[] urls = new URL[]{templateDirectoryUrl};
                URLClassLoader urlClassloader = new URLClassLoader(urls);
                this.siteRenderer.setTemplateClassLoader((ClassLoader)urlClassloader);
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException(this.templateDirectory + " isn't a valid URL.", (Exception)e);
            }
        }
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        if (this.attributes.get("project") == null) {
            this.attributes.put("project", this.project);
        }
        if (this.attributes.get("outputEncoding") == null) {
            this.attributes.put("outputEncoding", this.outputEncoding);
        }
        List reports = this.filterReports(this.reports);
        Map categories = this.categorizeReports(reports);
        ReportComparator reportComparator = new ReportComparator();
        List projectInfos = (List)categories.get("Project Info");
        List projectReports = (List)categories.get("Project Reports");
        if (projectInfos == null) {
            projectInfos = Collections.EMPTY_LIST;
        }
        if (projectReports == null) {
            projectReports = Collections.EMPTY_LIST;
        }
        Collections.sort(projectInfos, reportComparator);
        Collections.sort(projectReports, reportComparator);
        try {
            List<Locale> localesList = this.initLocalesList();
            if (localesList.isEmpty()) {
                localesList = Collections.singletonList(Locale.ENGLISH);
            }
            Locale defaultLocale = localesList.get(0);
            Locale.setDefault(defaultLocale);
            Iterator<Locale> iterator = localesList.iterator();
            while (iterator.hasNext()) {
                MavenProject parentProject;
                Locale locale = iterator.next();
                File outputDirectory = this.getOutputDirectory(locale, defaultLocale);
                if (!outputDirectory.exists()) {
                    outputDirectory.mkdirs();
                }
                File siteDirectoryFile = this.siteDirectory;
                if (!locale.getLanguage().equals(defaultLocale.getLanguage())) {
                    siteDirectoryFile = new File(this.siteDirectory, locale.getLanguage());
                }
                LinkedHashMap duplicate = new LinkedHashMap();
                String defaultExcludes = StringUtils.join((Object[])FileUtils.getDefaultExcludes(), (String)",");
                if (siteDirectoryFile.exists()) {
                    String actualExcludes = defaultExcludes + "," + "resources/**";
                    SiteMojo.tryToFindDuplicates(siteDirectoryFile, actualExcludes, duplicate);
                }
                if (this.generatedSiteDirectory.exists()) {
                    SiteMojo.tryToFindDuplicates(this.generatedSiteDirectory, defaultExcludes, duplicate);
                }
                this.checkDuplicates(duplicate, locale);
                String siteDescriptor = this.getSiteDescriptor(reports, locale, projectInfos, projectReports);
                List generatedReportsFileName = Collections.EMPTY_LIST;
                if (reports != null) {
                    generatedReportsFileName = this.generateReportsPages(reports, locale, outputDirectory, defaultLocale, siteDescriptor);
                }
                if (projectInfos.size() > 0) {
                    this.generateProjectInfoPage(siteDescriptor, locale, projectInfos, outputDirectory);
                }
                if (projectReports.size() > 0) {
                    this.generateProjectReportsPage(siteDescriptor, locale, projectReports, outputDirectory);
                }
                String displayLanguage = locale.getDisplayLanguage(Locale.ENGLISH);
                if (duplicate.get("index") != null) {
                    this.getLog().info((CharSequence)("Ignoring the index file generation for the " + displayLanguage + " version."));
                } else {
                    this.getLog().info((CharSequence)("Generate an index file for the " + displayLanguage + " version."));
                    this.generateIndexPage(siteDescriptor, locale, outputDirectory);
                }
                Iterator it = generatedReportsFileName.iterator();
                while (it.hasNext()) {
                    String reportFileName = (String)it.next();
                    if (duplicate.get(reportFileName) == null) continue;
                    this.getLog().info((CharSequence)("Override the generated file \"" + reportFileName + "\" for the " + displayLanguage + " version."));
                }
                this.siteRenderer.render(siteDirectoryFile, outputDirectory, siteDescriptor, this.template, this.attributes, locale);
                this.copyResources(outputDirectory);
                if (this.resourcesDirectory != null && this.resourcesDirectory.exists()) {
                    this.copyDirectory(this.resourcesDirectory, outputDirectory);
                }
                if (!this.addModules || (parentProject = this.project.getParent()) != null) {
                    // empty if block
                }
                if (!this.generatedSiteDirectory.exists()) continue;
                this.siteRenderer.render(this.generatedSiteDirectory, outputDirectory, siteDescriptor, this.template, this.attributes, locale);
            }
        }
        catch (MavenReportException e) {
            throw new MojoExecutionException("Error during report generation", (Exception)((Object)e));
        }
        catch (RendererException e) {
            throw new MojoExecutionException("Error during page generation", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error during site generation", (Exception)e);
        }
    }

    private List filterReports(List reports) {
        ArrayList<MavenReport> filteredReports = new ArrayList<MavenReport>(reports.size());
        Iterator i = reports.iterator();
        while (i.hasNext()) {
            MavenReport report = (MavenReport)i.next();
            try {
                if (!report.canGenerateReport()) continue;
                filteredReports.add(report);
            }
            catch (AbstractMethodError e) {
                this.getLog().warn((CharSequence)("Error loading report " + report.getClass().getName() + " - AbstractMethodError: canGenerateReport()"));
                filteredReports.add(report);
            }
        }
        return filteredReports;
    }

    private Map categorizeReports(List reports) {
        HashMap<String, ArrayList<MavenReport>> categories = new HashMap<String, ArrayList<MavenReport>>();
        Iterator i = reports.iterator();
        while (i.hasNext()) {
            MavenReport report = (MavenReport)i.next();
            ArrayList<MavenReport> category = (ArrayList<MavenReport>)categories.get(report.getCategoryName());
            if (category == null) {
                category = new ArrayList<MavenReport>();
                categories.put(report.getCategoryName(), category);
            }
            category.add(report);
        }
        return categories;
    }

    private List initLocalesList() {
        if (this.locales == null) {
            return Collections.EMPTY_LIST;
        }
        String[] localesArray = StringUtils.split((String)this.locales, (String)",");
        ArrayList<Locale> localesList = new ArrayList<Locale>();
        for (int i = 0; i < localesArray.length; ++i) {
            Locale locale = this.codeToLocale(localesArray[i]);
            if (locale == null) continue;
            if (!Arrays.asList(Locale.getAvailableLocales()).contains(locale)) {
                this.getLog().warn((CharSequence)("The locale parsed defined by '" + locale + "' is not available in this Java Virtual Machine (" + System.getProperty("java.version") + " from " + System.getProperty("java.vendor") + ") - IGNORING"));
                continue;
            }
            if (!this.i18n.getBundle("site-plugin", locale).getLocale().getLanguage().equals(locale.getLanguage())) {
                StringBuffer sb = new StringBuffer();
                sb.append("The locale '").append(locale).append("' (");
                sb.append(locale.getDisplayName(Locale.ENGLISH));
                sb.append(") is not currently support by Maven - IGNORING. ");
                sb.append("\n");
                sb.append("Contribution are welcome and greatly appreciated! ");
                sb.append("\n");
                sb.append("If you want to contribute a new translation, please visit ");
                sb.append("http://maven.apache.org/maven2/plugins/maven-site-plugin/i18n.html ");
                sb.append("for detailed instructions.");
                this.getLog().warn((CharSequence)sb.toString());
                continue;
            }
            localesList.add(locale);
        }
        return localesList;
    }

    private String getReportsMenu(Locale locale, List projectInfos, List projectReports) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<menu name=\"");
        buffer.append(this.i18n.getString("site-plugin", locale, "report.menu.projectdocumentation"));
        buffer.append("\">\n");
        buffer.append("    <item name=\"");
        buffer.append(this.i18n.getString("site-plugin", locale, "report.menu.about"));
        buffer.append(" ");
        buffer.append(this.project.getName());
        buffer.append("\" href=\"/index.html\"/>\n");
        this.writeReportSubMenu(projectInfos, buffer, locale, "report.menu.projectinformation", "project-info.html");
        this.writeReportSubMenu(projectReports, buffer, locale, "report.menu.projectreports", "maven-reports.html");
        buffer.append("</menu>\n");
        return buffer.toString();
    }

    private void writeReportSubMenu(List reports, StringBuffer buffer, Locale locale, String key, String indexFilename) {
        if (reports.size() > 0) {
            buffer.append("    <item name=\"");
            buffer.append(this.i18n.getString("site-plugin", locale, key));
            buffer.append("\" href=\"/");
            buffer.append(indexFilename);
            buffer.append("\" collapse=\"true\">\n");
            Iterator i = reports.iterator();
            while (i.hasNext()) {
                MavenReport report = (MavenReport)i.next();
                buffer.append("        <item name=\"");
                buffer.append(report.getName(locale));
                buffer.append("\" href=\"/");
                buffer.append(report.getOutputName());
                buffer.append(".html\"/>\n");
            }
            buffer.append("    </item>\n");
        }
    }

    private String getModulesMenu(Locale locale) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<menu name=\"");
        buffer.append(this.i18n.getString("site-plugin", locale, "report.menu.projectmodules"));
        buffer.append("\">\n");
        List modules = this.project.getModules();
        if (this.project.getModules() != null) {
            Iterator it = modules.iterator();
            while (it.hasNext()) {
                String module = (String)it.next();
                buffer.append("    <item name=\"");
                buffer.append(module);
                buffer.append("\" href=\"");
                buffer.append(module);
                buffer.append("/index.html\"/>\n");
            }
        }
        buffer.append("</menu>\n");
        return buffer.toString();
    }

    private String getProjectParentMenu(Locale locale) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<menu name=\"");
        buffer.append(this.i18n.getString("site-plugin", locale, "report.menu.parentproject"));
        buffer.append("\">\n");
        buffer.append("    <item name=\"");
        buffer.append(this.project.getParent().getArtifactId());
        buffer.append("\" href=\"../index.html\"/>\n");
        buffer.append("</menu>\n");
        return buffer.toString();
    }

    private String getSiteDescriptor(List reports, Locale locale, List projectInfos, List projectReports) throws MojoExecutionException {
        String siteDescriptorContent;
        File siteDescriptor = new File(this.siteDirectory, "site_" + locale.getLanguage() + ".xml");
        try {
            siteDescriptorContent = siteDescriptor.exists() ? FileUtils.fileRead((File)siteDescriptor) : ((siteDescriptor = new File(this.siteDirectory, "site.xml")).exists() ? FileUtils.fileRead((File)siteDescriptor) : IOUtil.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/default-site.xml")));
        }
        catch (IOException e) {
            throw new MojoExecutionException("The site descriptor cannot be read!", (Exception)e);
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("outputEncoding", this.outputEncoding);
        if (reports != null) {
            props.put("reports", this.getReportsMenu(locale, projectInfos, projectReports));
        }
        if (this.project.getParent() != null) {
            // empty if block
        }
        if (!this.addModules || this.project.getModules() == null || this.project.getModules().size() > 0) {
            // empty if block
        }
        if (this.project.getName() != null) {
            props.put("project.name", this.project.getName());
        } else {
            props.put("project.name", "NO_PROJECT_NAME_SET");
        }
        if (this.project.getUrl() != null) {
            props.put("project.url", this.project.getUrl());
        } else {
            props.put("project.url", "NO_PROJECT_URL_SET");
        }
        siteDescriptorContent = StringUtils.interpolate((String)siteDescriptorContent, props);
        return siteDescriptorContent;
    }

    private void generateIndexPage(String siteDescriptor, Locale locale, File outputDirectory) throws RendererException, IOException {
        String outputFileName = "index.html";
        SiteRendererSink sink = this.siteRenderer.createSink(this.siteDirectory, outputFileName, siteDescriptor);
        String title = this.i18n.getString("site-plugin", locale, "report.index.title").trim() + " " + this.project.getName();
        sink.head();
        sink.title();
        sink.text(title);
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(title);
        sink.sectionTitle1_();
        sink.paragraph();
        if (this.project.getDescription() != null) {
            sink.text(this.project.getDescription());
        } else {
            sink.text(this.i18n.getString("site-plugin", locale, "report.index.nodescription"));
        }
        sink.paragraph_();
        sink.body_();
        sink.flush();
        sink.close();
        File outputFile = new File(outputDirectory, outputFileName);
        this.siteRenderer.generateDocument((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), this.outputEncoding), this.template, this.attributes, sink, locale);
    }

    private List generateReportsPages(List reports, Locale locale, File localeOutputDirectory, Locale defaultLocale, String siteDescriptor) throws RendererException, IOException, MavenReportException {
        ArrayList<String> generatedReportsFileName = new ArrayList<String>();
        Iterator j = reports.iterator();
        while (j.hasNext()) {
            MavenReport report = (MavenReport)j.next();
            this.getLog().info((CharSequence)("Generate \"" + report.getName(locale) + "\" report."));
            report.setReportOutputDirectory(localeOutputDirectory);
            String reportFileName = report.getOutputName();
            if (locale.equals(defaultLocale)) {
                generatedReportsFileName.add(reportFileName);
            } else {
                generatedReportsFileName.add(locale.getLanguage() + File.separator + reportFileName);
            }
            String outputFileName = reportFileName + ".html";
            SiteRendererSink sink = this.siteRenderer.createSink(this.siteDirectory, outputFileName, siteDescriptor);
            report.generate((Sink)sink, locale);
            if (report.isExternalReport()) continue;
            File outputFile = new File(localeOutputDirectory, outputFileName);
            if (!outputFile.getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            this.siteRenderer.generateDocument((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), this.outputEncoding), this.template, this.attributes, sink, locale);
        }
        return generatedReportsFileName;
    }

    private void generateProjectInfoPage(String siteDescriptor, Locale locale, List projectInfos, File outputDirectory) throws RendererException, IOException {
        String outputFileName = "project-info.html";
        SiteRendererSink sink = this.siteRenderer.createSink(this.siteDirectory, outputFileName, siteDescriptor);
        String title = this.i18n.getString("site-plugin", locale, "report.information.title");
        sink.head();
        sink.title();
        sink.text(title);
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(title);
        sink.sectionTitle1_();
        sink.paragraph();
        sink.text(this.i18n.getString("site-plugin", locale, "report.information.description1") + " ");
        sink.link("http://maven.apache.org");
        sink.text("Maven");
        sink.link_();
        sink.text(" " + this.i18n.getString("site-plugin", locale, "report.information.description2"));
        sink.paragraph_();
        sink.section2();
        sink.sectionTitle2();
        sink.text(this.i18n.getString("site-plugin", locale, "report.information.sectionTitle"));
        sink.sectionTitle2_();
        sink.table();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(this.i18n.getString("site-plugin", locale, "report.information.column.document"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(this.i18n.getString("site-plugin", locale, "report.information.column.description"));
        sink.tableHeaderCell_();
        sink.tableRow_();
        Iterator i = projectInfos.iterator();
        while (i.hasNext()) {
            MavenReport report = (MavenReport)i.next();
            sink.tableRow();
            sink.tableCell();
            sink.link(report.getOutputName() + ".html");
            sink.text(report.getName(locale));
            sink.link_();
            sink.tableCell_();
            sink.tableCell();
            sink.text(report.getDescription(locale));
            sink.tableCell_();
            sink.tableRow_();
        }
        sink.table_();
        sink.section2_();
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
        File outputFile = new File(outputDirectory, outputFileName);
        this.siteRenderer.generateDocument((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), this.outputEncoding), this.template, this.attributes, sink, locale);
    }

    private void generateProjectReportsPage(String siteDescriptor, Locale locale, List projectReports, File outputDirectory) throws RendererException, IOException {
        String outputFileName = "maven-reports.html";
        SiteRendererSink sink = this.siteRenderer.createSink(this.siteDirectory, outputFileName, siteDescriptor);
        String title = this.i18n.getString("site-plugin", locale, "report.project.title");
        sink.head();
        sink.title();
        sink.text(title);
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(title);
        sink.sectionTitle1_();
        sink.paragraph();
        sink.text(this.i18n.getString("site-plugin", locale, "report.project.description1") + " ");
        sink.link("http://maven.apache.org");
        sink.text("Maven");
        sink.link_();
        sink.text(". " + this.i18n.getString("site-plugin", locale, "report.project.description2"));
        sink.paragraph_();
        sink.section2();
        sink.sectionTitle2();
        sink.text(this.i18n.getString("site-plugin", locale, "report.project.sectionTitle"));
        sink.sectionTitle2_();
        sink.table();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(this.i18n.getString("site-plugin", locale, "report.project.column.document"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(this.i18n.getString("site-plugin", locale, "report.project.column.description"));
        sink.tableHeaderCell_();
        sink.tableRow_();
        Iterator i = projectReports.iterator();
        while (i.hasNext()) {
            MavenReport report = (MavenReport)i.next();
            sink.tableRow();
            sink.tableCell();
            sink.link(report.getOutputName() + ".html");
            sink.text(report.getName(locale));
            sink.link_();
            sink.tableCell_();
            sink.tableCell();
            sink.text(report.getDescription(locale));
            sink.tableCell_();
            sink.tableRow_();
        }
        sink.table_();
        sink.section2_();
        sink.section1_();
        sink.body_();
        File outputFile = new File(outputDirectory, outputFileName);
        this.siteRenderer.generateDocument((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), this.outputEncoding), this.template, this.attributes, sink, locale);
    }

    private void copyResources(File outputDir) throws IOException {
        InputStream resourceList = this.getStream("org/apache/maven/plugins/site/resources.txt");
        if (resourceList != null) {
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(resourceList));
            String line = reader.readLine();
            while (line != null) {
                InputStream is = this.getStream("org/apache/maven/plugins/site/" + line);
                if (is == null) {
                    throw new IOException("The resource " + line + " doesn't exists in " + DEFAULT_TEMPLATE + " template.");
                }
                File outputFile = new File(outputDir, line);
                if (!outputFile.getParentFile().exists()) {
                    outputFile.getParentFile().mkdirs();
                }
                FileOutputStream w = new FileOutputStream(outputFile);
                IOUtil.copy((InputStream)is, (OutputStream)w);
                IOUtil.close((InputStream)is);
                IOUtil.close((OutputStream)w);
                line = reader.readLine();
            }
        }
    }

    private InputStream getStream(String name) {
        return (class$org$apache$maven$plugins$site$SiteMojo == null ? (class$org$apache$maven$plugins$site$SiteMojo = SiteMojo.class$("org.apache.maven.plugins.site.SiteMojo")) : class$org$apache$maven$plugins$site$SiteMojo).getClassLoader().getResourceAsStream(name);
    }

    private void copyDirectory(File source, File destination) throws IOException {
        if (source.exists()) {
            DirectoryScanner scanner = new DirectoryScanner();
            String[] includedResources = new String[]{"**/**"};
            scanner.setIncludes(includedResources);
            scanner.addDefaultExcludes();
            scanner.setBasedir(source);
            scanner.scan();
            List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
            Iterator<String> j = includedFiles.iterator();
            while (j.hasNext()) {
                String name = j.next();
                File sourceFile = new File(source, name);
                File destinationFile = new File(destination, name);
                FileUtils.copyFile((File)sourceFile, (File)destinationFile);
            }
        }
    }

    private File getOutputDirectory(Locale locale, Locale defaultLocale) {
        if (locale.getLanguage().equals(defaultLocale.getLanguage())) {
            return this.outputDirectory;
        }
        return new File(this.outputDirectory, locale.getLanguage());
    }

    private static void tryToFindDuplicates(File directory, String defaultExcludes, Map duplicate) throws IOException {
        List siteFiles = FileUtils.getFileNames((File)directory, null, (String)defaultExcludes, (boolean)false);
        Iterator it = siteFiles.iterator();
        while (it.hasNext()) {
            String currentFile = (String)it.next();
            if (currentFile.lastIndexOf(File.separator) == -1 || currentFile.lastIndexOf(".") == -1 || currentFile.startsWith(".")) continue;
            String key = currentFile.substring(currentFile.indexOf(File.separator) + 1, currentFile.lastIndexOf("."));
            ArrayList<String> tmp = (ArrayList<String>)duplicate.get(key.toLowerCase());
            if (tmp == null) {
                tmp = new ArrayList<String>();
                duplicate.put(key.toLowerCase(), tmp);
            }
            tmp.add(currentFile);
        }
    }

    private void checkDuplicates(Map duplicate, Locale locale) throws MojoFailureException {
        if (duplicate.size() > 0) {
            StringBuffer sb = null;
            Iterator it = duplicate.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Collection values = (Collection)entry.getValue();
                if (values.size() <= 1) continue;
                if (sb == null) {
                    sb = new StringBuffer("Some files are duplicates in the site directory or in the generated-site directory. ");
                    sb.append("\n");
                    sb.append("Review the following files for the \"");
                    sb.append(locale.getDisplayLanguage(Locale.ENGLISH));
                    sb.append("\" version:");
                }
                sb.append("\n");
                sb.append(entry.getKey());
                sb.append("\n");
                Iterator it2 = values.iterator();
                while (it2.hasNext()) {
                    String current = (String)it2.next();
                    sb.append("\t");
                    sb.append(current);
                    if (!it2.hasNext()) continue;
                    sb.append("\n");
                }
            }
            if (sb != null) {
                throw new MojoFailureException(sb.toString());
            }
        }
    }

    private Locale codeToLocale(String localeCode) {
        if (localeCode == null) {
            return null;
        }
        if ("default".equalsIgnoreCase(localeCode)) {
            return Locale.getDefault();
        }
        String language = "";
        String country = "";
        String variant = "";
        StringTokenizer tokenizer = new StringTokenizer(localeCode, "_");
        if (tokenizer.countTokens() > 3) {
            this.getLog().warn((CharSequence)("Invalid java.util.Locale format for '" + localeCode + "' entry - IGNORING"));
            return null;
        }
        if (tokenizer.hasMoreTokens()) {
            language = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                country = tokenizer.nextToken();
                if (tokenizer.hasMoreTokens()) {
                    variant = tokenizer.nextToken();
                }
            }
        }
        return new Locale(language, country, variant);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

