/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.surefire.report;

import java.io.File;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.surefire.report.AbstractSurefireReportMojo;
import org.apache.maven.project.MavenProject;

@Mojo(name="report", inheritByDefault=false)
@Execute(lifecycle="surefire", phase=LifecyclePhase.TEST)
public class SurefireReportMojo
extends AbstractSurefireReportMojo {
    @Parameter(defaultValue="surefire-report", property="outputName", required=true)
    private String outputName;
    @Parameter(defaultValue="true", property="alwaysGenerateSurefireReport")
    private boolean alwaysGenerateSurefireReport;
    @Parameter(defaultValue="false", property="skipSurefireReport")
    private boolean skipSurefireReport;

    @Override
    protected File getSurefireReportsDirectory(MavenProject subProject) {
        String buildDir = subProject.getBuild().getDirectory();
        return new File(buildDir, "surefire-reports");
    }

    @Override
    public String getOutputName() {
        return this.outputName;
    }

    @Override
    protected boolean isSkipped() {
        return this.skipSurefireReport;
    }

    @Override
    protected boolean isGeneratedWhenNoResults() {
        return this.alwaysGenerateSurefireReport;
    }

    @Override
    protected String getI18Nsection() {
        return "surefire";
    }
}

