/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractWarMojo
extends AbstractMojo {
    private MavenProject project;
    private File classesDirectory;
    private File webappDirectory;
    private File warSourceDirectory;
    private String webXml;
    public static final String WEB_INF = "WEB-INF";
    private String warSourceIncludes = "**";
    private String warSourceExcludes;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public abstract void execute() throws MojoExecutionException;

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public File getClassesDirectory() {
        return this.classesDirectory;
    }

    public void setClassesDirectory(File classesDirectory) {
        this.classesDirectory = classesDirectory;
    }

    public File getWebappDirectory() {
        return this.webappDirectory;
    }

    public void setWebappDirectory(File webappDirectory) {
        this.webappDirectory = webappDirectory;
    }

    public File getWarSourceDirectory() {
        return this.warSourceDirectory;
    }

    public void setWarSourceDirectory(File warSourceDirectory) {
        this.warSourceDirectory = warSourceDirectory;
    }

    public String getWebXml() {
        return this.webXml;
    }

    public void setWebXml(String webXml) {
        this.webXml = webXml;
    }

    protected String[] getExcludes() {
        ArrayList<String> excludeList = new ArrayList<String>(FileUtils.getDefaultExcludesAsList());
        if (this.warSourceExcludes != null && !"".equals(this.warSourceExcludes)) {
            excludeList.add(this.warSourceExcludes);
        }
        if (this.getWebXml() != null && !"".equals(this.getWebXml())) {
            excludeList.add("**/WEB-INF/web.xml");
        }
        return excludeList.toArray(EMPTY_STRING_ARRAY);
    }

    protected String[] getIncludes() {
        return new String[]{this.warSourceIncludes};
    }

    public void buildExplodedWebapp(File webappDirectory) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Exploding webapp...");
        webappDirectory.mkdirs();
        File webinfDir = new File(webappDirectory, WEB_INF);
        webinfDir.mkdirs();
        try {
            this.copyResources(this.getWarSourceDirectory(), webappDirectory, this.getWebXml());
            this.buildWebapp(this.getProject(), webappDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not explode webapp...", (Exception)e);
        }
    }

    public void copyResources(File sourceDirectory, File webappDirectory, String webXml) throws IOException {
        if (!sourceDirectory.equals(webappDirectory)) {
            this.getLog().info((CharSequence)("Copy webapp resources to " + webappDirectory.getAbsolutePath()));
            if (this.getWarSourceDirectory().exists()) {
                String[] fileNames = this.getWarFiles(sourceDirectory);
                for (int i = 0; i < fileNames.length; ++i) {
                    FileUtils.copyFile((File)new File(sourceDirectory, fileNames[i]), (File)new File(webappDirectory, fileNames[i]));
                }
            }
            if (webXml != null && !"".equals(webXml)) {
                File webinfDir = new File(webappDirectory, WEB_INF);
                FileUtils.copyFile((File)new File(webXml), (File)new File(webinfDir, "/web.xml"));
            }
        }
    }

    public void buildWebapp(MavenProject project, File webappDirectory) throws IOException {
        this.getLog().info((CharSequence)("Assembling webapp " + project.getArtifactId() + " in " + webappDirectory));
        File libDirectory = new File(webappDirectory, "WEB-INF/lib");
        File tldDirectory = new File(webappDirectory, "WEB-INF/tld");
        File webappClassesDirectory = new File(webappDirectory, "WEB-INF/classes");
        if (this.getClassesDirectory().exists()) {
            FileUtils.copyDirectoryStructure((File)this.getClassesDirectory(), (File)webappClassesDirectory);
        }
        Set artifacts = project.getArtifacts();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            if ("provided".equals(artifact.getScope()) || "test".equals(artifact.getScope())) continue;
            String type = artifact.getType();
            if ("tld".equals(type)) {
                FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)tldDirectory);
                continue;
            }
            if ("jar".equals(type) || "ejb".equals(type) || "ejb-client".equals(type)) {
                FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)libDirectory);
                continue;
            }
            this.getLog().debug((CharSequence)("Skipping artifact of type " + type + " for WEB-INF/lib"));
        }
    }

    private String[] getWarFiles(File sourceDir) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceDir);
        scanner.setExcludes(this.getExcludes());
        scanner.addDefaultExcludes();
        scanner.setIncludes(this.getIncludes());
        scanner.scan();
        return scanner.getIncludedFiles();
    }
}

