/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.war.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugins.war.util.PathSet;
import org.apache.maven.plugins.war.util.WebappStructure;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

public class WebappStructureSerializer {
    private static final XStream XSTREAM = new XStream((HierarchicalStreamDriver)new DomDriver());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebappStructure fromXml(File file) throws IOException {
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)file);
            WebappStructure webappStructure = (WebappStructure)XSTREAM.fromXML((Reader)reader);
            reader.close();
            reader = null;
            WebappStructure webappStructure2 = webappStructure;
            return webappStructure2;
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toXml(WebappStructure webappStructure, File targetFile) throws IOException {
        XmlStreamWriter writer = null;
        try {
            if (!targetFile.getParentFile().exists() && !targetFile.getParentFile().mkdirs()) {
                throw new IOException("Could not create parent [" + targetFile.getParentFile().getAbsolutePath() + "]");
            }
            if (!targetFile.exists() && !targetFile.createNewFile()) {
                throw new IOException("Could not create file [" + targetFile.getAbsolutePath() + "]");
            }
            writer = WriterFactory.newXmlWriter((File)targetFile);
            XSTREAM.toXML((Object)webappStructure, (Writer)writer);
            writer.close();
            writer = null;
        }
        catch (Throwable throwable) {
            IOUtil.close(writer);
            throw throwable;
        }
        IOUtil.close((Writer)writer);
    }

    static {
        XSTREAM.alias("webapp-structure", WebappStructure.class);
        XSTREAM.alias("path-set", PathSet.class);
        XSTREAM.alias("dependency", Dependency.class);
    }
}

