/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.wrapper;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.maven.Maven;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

@Mojo(name="wrapper", aggregator=true, requiresProject=false)
public class WrapperMojo
extends AbstractMojo {
    private static final String MVNW_REPOURL = "MVNW_REPOURL";
    protected static final String DEFAULT_REPOURL = "https://repo.maven.apache.org/maven2";
    @Parameter(property="maven")
    private String mavenVersion;
    @Parameter(property="mvnd")
    private String mvndVersion;
    @Parameter(property="type")
    private String distributionType;
    @Parameter(defaultValue="false", property="includeDebug")
    private boolean includeDebugScript;
    @Parameter(property="wrapperSha256Sum")
    private String wrapperSha256Sum;
    @Parameter(property="distributionSha256Sum")
    private String distributionSha256Sum;
    @Parameter(defaultValue="false", property="alwaysDownload")
    private boolean alwaysDownload;
    @Parameter(defaultValue="false", property="alwaysUnpack")
    private boolean alwaysUnpack;
    @Component
    private MavenSession session;
    private static final String WRAPPER_DISTRIBUTION_GROUP_ID = "org.apache.maven.wrapper";
    private static final String WRAPPER_DISTRIBUTION_ARTIFACT_ID = "maven-wrapper-distribution";
    private static final String WRAPPER_DISTRIBUTION_EXTENSION = "zip";
    private static final String WRAPPER_DIR = ".mvn/wrapper";
    private static final String WRAPPER_PROPERTIES_FILENAME = "maven-wrapper.properties";
    private static final String DISTRIBUTION_TYPE_PROPERTY_NAME = "distributionType";
    private static final String TYPE_ONLY_SCRIPT = "only-script";
    private static final String DEFAULT_DISTRIBUTION_TYPE = "only-script";
    @Inject
    private RepositorySystem repositorySystem;
    @Inject
    private Map<String, UnArchiver> unarchivers;

    public void execute() throws MojoExecutionException {
        Path baseDir = Paths.get(this.session.getRequest().getBaseDirectory(), new String[0]);
        Path wrapperDir = baseDir.resolve(WRAPPER_DIR);
        if (this.distributionType == null) {
            this.distributionType = this.determineDistributionType(wrapperDir);
        }
        if (this.mvndVersion != null && this.mvndVersion.length() > 0 && !"only-script".equals(this.distributionType)) {
            throw new MojoExecutionException("maven-wrapper with type=" + this.distributionType + " cannot work with mvnd, please set type to '" + "only-script" + "'.");
        }
        this.mavenVersion = this.getVersion(this.mavenVersion, Maven.class, "org.apache.maven/maven-core");
        String wrapperVersion = this.getVersion(null, ((Object)((Object)this)).getClass(), "org.apache.maven.plugins/maven-wrapper-plugin");
        Artifact artifact = this.downloadWrapperDistribution(wrapperVersion);
        this.createDirectories(wrapperDir);
        this.cleanup(wrapperDir);
        this.unpack(artifact, baseDir);
        this.replaceProperties(wrapperVersion, wrapperDir);
    }

    private String determineDistributionType(Path wrapperDir) {
        String typeFromMavenWrapperProperties = this.distributionTypeFromExistingMavenWrapperProperties(wrapperDir);
        if (typeFromMavenWrapperProperties != null) {
            return typeFromMavenWrapperProperties;
        }
        return "only-script";
    }

    private String distributionTypeFromExistingMavenWrapperProperties(Path wrapperDir) {
        String string;
        block8: {
            Path mavenWrapperProperties = wrapperDir.resolve(WRAPPER_PROPERTIES_FILENAME);
            InputStream inputStream = Files.newInputStream(mavenWrapperProperties, new OpenOption[0]);
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                string = properties.getProperty(DISTRIBUTION_TYPE_PROPERTY_NAME);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            inputStream.close();
        }
        return string;
    }

    private void createDirectories(Path dir) throws MojoExecutionException {
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
        }
    }

    private void cleanup(Path wrapperDir) throws MojoExecutionException {
        try (DirectoryStream<Path> dsClass = Files.newDirectoryStream(wrapperDir, "*.class");){
            for (Path file : dsClass) {
                Files.deleteIfExists(file);
            }
            Files.deleteIfExists(wrapperDir.resolve("MavenWrapperDownloader.java"));
            Files.deleteIfExists(wrapperDir.resolve("maven-wrapper.jar"));
        }
        catch (IOException ioe) {
            throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
        }
    }

    private Artifact downloadWrapperDistribution(String wrapperVersion) throws MojoExecutionException {
        DefaultArtifact artifact = new DefaultArtifact(WRAPPER_DISTRIBUTION_GROUP_ID, WRAPPER_DISTRIBUTION_ARTIFACT_ID, this.distributionType, WRAPPER_DISTRIBUTION_EXTENSION, wrapperVersion);
        ArtifactRequest request = new ArtifactRequest();
        request.setRepositories(this.session.getCurrentProject().getRemotePluginRepositories());
        request.setArtifact((Artifact)artifact);
        try {
            ArtifactResult artifactResult = this.repositorySystem.resolveArtifact(this.session.getRepositorySession(), request);
            return artifactResult.getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("artifact: " + artifact + " not resolved.", (Exception)((Object)e));
        }
    }

    private void unpack(Artifact artifact, Path targetFolder) {
        UnArchiver unarchiver = this.unarchivers.get(WRAPPER_DISTRIBUTION_EXTENSION);
        unarchiver.setDestDirectory(targetFolder.toFile());
        unarchiver.setSourceFile(artifact.getFile());
        if (!this.includeDebugScript) {
            unarchiver.setFileSelectors(new FileSelector[]{fileInfo -> !fileInfo.getName().contains("Debug")});
        }
        unarchiver.extract();
        this.getLog().info((CharSequence)("Unpacked " + MessageUtils.buffer().strong((Object)this.distributionType) + " type wrapper distribution " + artifact));
    }

    private void replaceProperties(String wrapperVersion, Path targetFolder) throws MojoExecutionException {
        String repoUrl = this.getRepoUrl();
        String distributionUrl = repoUrl + "/org/apache/maven/apache-maven/" + this.mavenVersion + "/apache-maven-" + this.mavenVersion + "-bin.zip";
        String wrapperUrl = repoUrl + "/org/apache/maven/wrapper/maven-wrapper/" + wrapperVersion + "/maven-wrapper-" + wrapperVersion + ".jar";
        if (this.mvndVersion != null && this.mvndVersion.length() > 0) {
            distributionUrl = "https://archive.apache.org/dist/maven/mvnd/" + this.mvndVersion + "/maven-mvnd-" + this.mvndVersion + "-bin.zip";
        }
        Path wrapperPropertiesFile = targetFolder.resolve(WRAPPER_PROPERTIES_FILENAME);
        this.getLog().info((CharSequence)("Configuring .mvn/wrapper/maven-wrapper.properties to use " + MessageUtils.buffer().strong((Object)("Maven " + this.mavenVersion)) + " and download from " + repoUrl));
        String license = "# Licensed to the Apache Software Foundation (ASF) under one%n# or more contributor license agreements.  See the NOTICE file%n# distributed with this work for additional information%n# regarding copyright ownership.  The ASF licenses this file%n# to you under the Apache License, Version 2.0 (the%n# \"License\"); you may not use this file except in compliance%n# with the License.  You may obtain a copy of the License at%n#%n#   http://www.apache.org/licenses/LICENSE-2.0%n#%n# Unless required by applicable law or agreed to in writing,%n# software distributed under the License is distributed on an%n# \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY%n# KIND, either express or implied.  See the License for the%n# specific language governing permissions and limitations%n# under the License.%n";
        try (BufferedWriter out = Files.newBufferedWriter(wrapperPropertiesFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            out.append(String.format(Locale.ROOT, "# Licensed to the Apache Software Foundation (ASF) under one%n# or more contributor license agreements.  See the NOTICE file%n# distributed with this work for additional information%n# regarding copyright ownership.  The ASF licenses this file%n# to you under the Apache License, Version 2.0 (the%n# \"License\"); you may not use this file except in compliance%n# with the License.  You may obtain a copy of the License at%n#%n#   http://www.apache.org/licenses/LICENSE-2.0%n#%n# Unless required by applicable law or agreed to in writing,%n# software distributed under the License is distributed on an%n# \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY%n# KIND, either express or implied.  See the License for the%n# specific language governing permissions and limitations%n# under the License.%n", new Object[0]));
            out.append("wrapperVersion=" + wrapperVersion + System.lineSeparator());
            out.append("distributionType=" + this.distributionType + System.lineSeparator());
            out.append("distributionUrl=" + distributionUrl + System.lineSeparator());
            if (this.distributionSha256Sum != null) {
                out.append("distributionSha256Sum=" + this.distributionSha256Sum + System.lineSeparator());
            }
            if (!this.distributionType.equals("only-script")) {
                out.append("wrapperUrl=" + wrapperUrl + System.lineSeparator());
            }
            if (this.wrapperSha256Sum != null) {
                out.append("wrapperSha256Sum=" + this.wrapperSha256Sum + System.lineSeparator());
            }
            if (this.alwaysDownload) {
                out.append("alwaysDownload=" + Boolean.TRUE + System.lineSeparator());
            }
            if (this.alwaysUnpack) {
                out.append("alwaysUnpack=" + Boolean.TRUE + System.lineSeparator());
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Can't create maven-wrapper.properties", (Exception)ioe);
        }
    }

    private String getVersion(String defaultVersion, Class<?> clazz, String path) {
        String version = defaultVersion;
        if (version == null || version.trim().length() == 0 || "true".equals(version)) {
            Properties props = new Properties();
            try (InputStream is = clazz.getResourceAsStream("/META-INF/maven/" + path + "/pom.properties");){
                if (is != null) {
                    props.load(is);
                    version = props.getProperty("version");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return version;
    }

    private String getRepoUrl() {
        String envRepoUrl = System.getenv(MVNW_REPOURL);
        String repoUrl = this.determineRepoUrl(envRepoUrl, this.session.getSettings());
        this.getLog().debug((CharSequence)("Determined repo URL to use as " + repoUrl));
        return repoUrl;
    }

    protected String determineRepoUrl(String envRepoUrl, Settings settings) {
        if (envRepoUrl != null && !envRepoUrl.trim().isEmpty() && envRepoUrl.length() > 4) {
            String repoUrl = envRepoUrl.trim();
            if (repoUrl.endsWith("/")) {
                repoUrl = repoUrl.substring(0, repoUrl.length() - 1);
            }
            this.getLog().debug((CharSequence)"Using repo URL from MVNW_REPOURL environment variable.");
            return repoUrl;
        }
        if (settings.getMirrors() != null && !settings.getMirrors().isEmpty()) {
            for (Mirror current : settings.getMirrors()) {
                if (!"*".equals(current.getMirrorOf())) continue;
                this.getLog().debug((CharSequence)"Using repo URL from * mirror in settings file.");
                return current.getUrl();
            }
        }
        return DEFAULT_REPOURL;
    }
}

