/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.util.MavenExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CiFriendlyVersion {
    private static final Logger LOGGER = LoggerFactory.getLogger(CiFriendlyVersion.class);
    public static final String REVISION = "revision";
    public static final String SHA1 = "sha1";
    public static final String CHANGELIST = "changelist";
    private static final Set<String> CI_FRIENDLY_PROPERTIES = new HashSet<String>(Arrays.asList("revision", "sha1", "changelist"));
    private static final String SNAPSHOT = "-SNAPSHOT";

    private CiFriendlyVersion() {
    }

    public static boolean isCiFriendlyVersion(String version) {
        if (StringUtils.isEmpty((CharSequence)version)) {
            return false;
        }
        return CiFriendlyVersion.isCiFriendlyProperty(MavenExpression.extractPropertyFromExpression(version));
    }

    public static boolean isCiFriendlyProperty(String property) {
        return CI_FRIENDLY_PROPERTIES.contains(property);
    }

    public static void rewriteCiFriendlyProperties(String version, Properties properties, ReleaseDescriptor releaseDescriptor) {
        if (properties != null) {
            String sha1 = CiFriendlyVersion.resolveSha1Property(properties, releaseDescriptor);
            if (ArtifactUtils.isSnapshot((String)version)) {
                if (properties.containsKey(CHANGELIST)) {
                    String revision = version.replace(sha1, "").replace(SNAPSHOT, "");
                    CiFriendlyVersion.setAndLogPropertyChange(properties, REVISION, revision);
                    CiFriendlyVersion.setAndLogPropertyChange(properties, CHANGELIST, SNAPSHOT);
                } else {
                    String revision = version.replace(sha1, "");
                    CiFriendlyVersion.setAndLogPropertyChange(properties, REVISION, revision);
                }
                if (properties.containsKey(SHA1)) {
                    CiFriendlyVersion.setAndLogPropertyChange(properties, SHA1, "");
                }
            } else {
                properties.setProperty(REVISION, version.replace(sha1, ""));
                if (properties.containsKey(CHANGELIST)) {
                    CiFriendlyVersion.setAndLogPropertyChange(properties, CHANGELIST, "");
                }
                if (properties.containsKey(SHA1) && !sha1.isEmpty()) {
                    CiFriendlyVersion.setAndLogPropertyChange(properties, SHA1, sha1);
                }
            }
        }
    }

    private static void setAndLogPropertyChange(Properties properties, String key, String value) {
        LOGGER.info("Updating CI friendly property {} to {}", (Object)key, (Object)value);
        properties.setProperty(key, value);
    }

    public static String resolveSha1Property(Properties properties, ReleaseDescriptor releaseDescriptor) {
        String sha1 = properties.getProperty(SHA1);
        String scmVersion = releaseDescriptor.getScmReleasedPomRevision();
        String systemSha1 = System.getProperty(SHA1);
        String result = StringUtils.isNotEmpty((CharSequence)systemSha1) ? systemSha1 : (StringUtils.isNotEmpty((CharSequence)sha1) ? sha1 : (scmVersion != null ? scmVersion : ""));
        LOGGER.info("Resolved SHA1 property value {}", (Object)result);
        return result;
    }
}

