/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.policy.oddeven;

import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.shared.release.policy.PolicyException;
import org.apache.maven.shared.release.policy.version.VersionPolicy;
import org.apache.maven.shared.release.policy.version.VersionPolicyRequest;
import org.apache.maven.shared.release.policy.version.VersionPolicyResult;
import org.apache.maven.shared.release.versions.Version;
import org.apache.maven.shared.release.versions.VersionParseException;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.sisu.Description;

@Singleton
@Named(value="OddEvenVersionPolicy")
@Description(value="A VersionPolicy implementation that selects even version numbers only for releases")
public final class OddEvenVersionPolicy
implements VersionPolicy {
    public VersionPolicyResult getReleaseVersion(VersionPolicyRequest request) throws PolicyException {
        return this.calculateNextVersion(request, false);
    }

    public VersionPolicyResult getDevelopmentVersion(VersionPolicyRequest request) throws PolicyException {
        return this.calculateNextVersion(request, true);
    }

    private VersionPolicyResult calculateNextVersion(VersionPolicyRequest request, boolean development) {
        Version defaultVersionInfo = null;
        try {
            defaultVersionInfo = new Version(request.getVersion());
        }
        catch (VersionParseException e) {
            throw new IllegalArgumentException("Can't tell if version with no digits is even: " + e.getMessage(), e);
        }
        Version newVersion = this.newVersion(defaultVersionInfo, development);
        return new VersionPolicyResult().setVersion(newVersion.toString());
    }

    private Version newVersion(Version defaultVersionInfo, boolean development) {
        Version newVersion;
        if (StringUtils.isNumeric((String)defaultVersionInfo.getAnnotationRevision())) {
            int mostSignificantSegment = Integer.parseInt(defaultVersionInfo.getAnnotationRevision());
            int skip = this.getVersionIncrements(development, mostSignificantSegment % 2 == 0);
            newVersion = defaultVersionInfo.setAnnotationRevision(String.valueOf(mostSignificantSegment + skip));
        } else {
            List digits = defaultVersionInfo.getDigits();
            if (digits == null) {
                throw new IllegalArgumentException("Can't tell if version with no digits is even.");
            }
            int mostSignificantSegment = Integer.parseInt((String)digits.get(digits.size() - 1));
            int skip = this.getVersionIncrements(development, mostSignificantSegment % 2 == 0);
            digits.set(digits.size() - 1, String.valueOf(String.valueOf(mostSignificantSegment + skip)));
            newVersion = defaultVersionInfo.setDigits(digits);
        }
        if (development) {
            return newVersion.setBuildSpecifier("SNAPSHOT");
        }
        return newVersion.setBuildSpecifier(null);
    }

    private int getVersionIncrements(boolean development, boolean isEven) {
        if (development && !isEven) {
            return 2;
        }
        if (!development && isEven) {
            return 0;
        }
        return 1;
    }
}

