/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.reporting;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkFactory;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.siterenderer.DocumentContent;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.RenderingContext;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.doxia.tools.SiteToolException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenMultiPageReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.util.ReaderFactory;

public abstract class AbstractMavenReport
extends AbstractMojo
implements MavenMultiPageReport {
    @Parameter(defaultValue="${project.reporting.outputDirectory}", readonly=true, required=true)
    protected File outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}", readonly=true)
    private String inputEncoding;
    @Parameter(property="outputEncoding", defaultValue="${project.reporting.outputEncoding}", readonly=true)
    private String outputEncoding;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    protected ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    protected List<ArtifactRepository> remoteRepositories;
    @Component
    protected SiteTool siteTool;
    @Component
    protected Renderer siteRenderer;
    private Sink sink;
    private SinkFactory sinkFactory;
    private File reportOutputDirectory;

    public void execute() throws MojoExecutionException {
        if (!this.canGenerateReport()) {
            return;
        }
        File outputDirectory = new File(this.getOutputDirectory());
        String filename = this.getOutputName() + ".html";
        Locale locale = Locale.getDefault();
        try {
            SiteRenderingContext siteContext = this.createSiteRenderingContext(locale);
            this.getSiteRenderer().copyResources(siteContext, outputDirectory);
            RenderingContext docRenderingContext = new RenderingContext(outputDirectory, filename, null);
            SiteRendererSink sink = new SiteRendererSink(docRenderingContext);
            this.generate((Sink)sink, null, locale);
            if (!this.isExternalReport()) {
                outputDirectory.mkdirs();
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(outputDirectory, filename)), this.getOutputEncoding());){
                    this.getSiteRenderer().mergeDocumentIntoSite((Writer)writer, (DocumentContent)sink, siteContext);
                }
            }
            this.getSiteRenderer().copyResources(siteContext, outputDirectory);
        }
        catch (IOException | RendererException | MavenReportException e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)e);
        }
    }

    private SiteRenderingContext createSiteRenderingContext(Locale locale) throws MavenReportException, IOException {
        SiteRenderingContext context;
        DecorationModel decorationModel = new DecorationModel();
        HashMap<String, Object> templateProperties = new HashMap<String, Object>();
        templateProperties.put("standalone", Boolean.TRUE);
        templateProperties.put("project", this.getProject());
        templateProperties.put("inputEncoding", this.getInputEncoding());
        templateProperties.put("outputEncoding", this.getOutputEncoding());
        for (Map.Entry<Object, Object> entry : this.getProject().getProperties().entrySet()) {
            templateProperties.put((String)entry.getKey(), entry.getValue());
        }
        try {
            Artifact skinArtifact = this.siteTool.getSkinArtifactFromRepository(this.localRepository, this.remoteRepositories, decorationModel);
            this.getLog().info((CharSequence)MessageUtils.buffer().a((CharSequence)"Rendering content with ").strong((Object)(skinArtifact.getId() + " skin")).a((Object)Character.valueOf('.')).toString());
            context = this.siteRenderer.createContextForSkin(skinArtifact, templateProperties, decorationModel, this.project.getName(), locale);
        }
        catch (SiteToolException e) {
            throw new MavenReportException("Failed to retrieve skin artifact", (Exception)((Object)e));
        }
        catch (RendererException e) {
            throw new MavenReportException("Failed to create context for skin", (Exception)((Object)e));
        }
        context.setRootDirectory(this.project.getBasedir());
        return context;
    }

    @Deprecated
    public void generate(org.codehaus.doxia.sink.Sink sink, Locale locale) throws MavenReportException {
        this.generate((Sink)sink, null, locale);
    }

    @Deprecated
    public void generate(Sink sink, Locale locale) throws MavenReportException {
        this.generate(sink, null, locale);
    }

    public void generate(Sink sink, SinkFactory sinkFactory, Locale locale) throws MavenReportException {
        if (!this.canGenerateReport()) {
            this.getLog().info((CharSequence)"This report cannot be generated as part of the current build. The report name should be referenced in this line of output.");
            return;
        }
        this.sink = sink;
        this.sinkFactory = sinkFactory;
        this.executeReport(locale);
        this.closeReport();
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public File getReportOutputDirectory() {
        if (this.reportOutputDirectory == null) {
            this.reportOutputDirectory = new File(this.getOutputDirectory());
        }
        return this.reportOutputDirectory;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.reportOutputDirectory = reportOutputDirectory;
        this.outputDirectory = reportOutputDirectory;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String getInputEncoding() {
        return this.inputEncoding == null ? ReaderFactory.FILE_ENCODING : this.inputEncoding;
    }

    protected String getOutputEncoding() {
        return this.outputEncoding == null ? "UTF-8" : this.outputEncoding;
    }

    protected void closeReport() {
        this.getSink().close();
    }

    public Sink getSink() {
        return this.sink;
    }

    public SinkFactory getSinkFactory() {
        return this.sinkFactory;
    }

    public boolean isExternalReport() {
        return false;
    }

    public boolean canGenerateReport() {
        return true;
    }

    protected abstract void executeReport(Locale var1) throws MavenReportException;
}

