/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.jdk;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.http.ChecksumExtractor;
import org.eclipse.aether.spi.connector.transport.http.HttpTransporter;
import org.eclipse.aether.spi.connector.transport.http.HttpTransporterFactory;
import org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.transport.jdk.JdkTransporter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Named(value="jdk")
public final class JdkTransporterFactory
implements HttpTransporterFactory {
    public static final String NAME = "jdk";
    private float priority = 10.0f;
    private final ChecksumExtractor checksumExtractor;

    @Inject
    public JdkTransporterFactory(ChecksumExtractor checksumExtractor) {
        this.checksumExtractor = Objects.requireNonNull(checksumExtractor, "checksumExtractor");
    }

    public float getPriority() {
        return this.priority;
    }

    public JdkTransporterFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    public HttpTransporter newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoTransporterException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        if (!"http".equalsIgnoreCase(repository.getProtocol()) && !"https".equalsIgnoreCase(repository.getProtocol())) {
            throw new NoTransporterException(repository, "Only HTTP/HTTPS is supported");
        }
        return new JdkTransporter(session, repository, JdkTransporterFactory.javaVersion(), this.checksumExtractor);
    }

    private static int javaVersion() {
        try {
            String version = System.getProperty("java.version", "11");
            int dot = version.indexOf(46);
            int hyphen = version.indexOf(45);
            int sep = dot > 0 && dot < hyphen || hyphen < 0 ? dot : hyphen;
            return Integer.parseInt(sep > 0 ? version.substring(0, sep) : version);
        }
        catch (NumberFormatException nfe) {
            return 11;
        }
    }
}

