/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.jdk;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.http.ChecksumExtractor;
import org.eclipse.aether.spi.connector.transport.http.HttpTransporter;
import org.eclipse.aether.spi.connector.transport.http.HttpTransporterFactory;
import org.eclipse.aether.transfer.NoTransporterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Named(value="jdk")
public final class JdkTransporterFactory
implements HttpTransporterFactory {
    public static final String NAME = "jdk";
    private static final Logger LOGGER = LoggerFactory.getLogger(JdkTransporterFactory.class);
    private float priority = 10.0f;

    @Inject
    public JdkTransporterFactory(ChecksumExtractor checksumExtractor) {
    }

    public float getPriority() {
        return this.priority;
    }

    public JdkTransporterFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    public HttpTransporter newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoTransporterException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        LOGGER.debug("Needs Java11+ to function");
        throw new NoTransporterException(repository, "JDK Transport needs Java11+");
    }
}

