/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.jgit.command.checkin;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkin.AbstractCheckInCommand;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.jgit.command.JGitUtils;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.UserConfig;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;

public class JGitCheckInCommand
extends AbstractCheckInCommand
implements GitCommand {
    protected static final String GIT_MAVEN_SECTION = "maven-scm";
    protected static final String GIT_MAILDOMAIN = "maildomain";
    protected static final String GIT_FORCE = "forceUsername";

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CheckInScmResult executeCheckInCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message, ScmVersion version) throws ScmException {
        block21: {
            git = null;
            try {
                basedir = fileSet.getBasedir();
                git = JGitUtils.openRepo(basedir);
                doCommit = false;
                if (!fileSet.getFileList().isEmpty()) {
                    v0 = doCommit = JGitUtils.addAllFiles(git, fileSet).size() > 0;
                    if (!doCommit) {
                        doCommit = git.status().call().hasUncommittedChanges();
                    }
                } else {
                    status = git.status().call();
                    changeds = git.status().call().getModified();
                    if (changeds.isEmpty()) {
                        if (!status.hasUncommittedChanges()) {
                            this.logger.warn("There are neither files to be added nor any uncommitted changes");
                            doCommit = false;
                        } else {
                            this.logger.debug("There are uncommitted changes in the git index");
                            doCommit = true;
                        }
                    } else {
                        add = git.add();
                        for (String changed : changeds) {
                            this.logger.debug("Add manually: {}", (Object)changed);
                            add.addFilepattern(changed);
                            doCommit = true;
                        }
                        add.call();
                    }
                }
                checkedInFiles = Collections.emptyList();
                if (doCommit) {
                    author = this.getAuthor(repo, git);
                    committer = this.getCommitter(repo, git);
                    command = git.commit().setMessage(message).setAuthor(author.name, author.email);
                    command.setCommitter(committer.name, committer.email);
                    commitRev = command.call();
                    this.logger.info("commit done: " + commitRev.getShortMessage());
                    checkedInFiles = JGitUtils.getFilesInCommit(git.getRepository(), commitRev, fileSet.getBasedir());
                    if (this.logger.isDebugEnabled()) {
                        for (ScmFile var14_15 : checkedInFiles) {
                            this.logger.debug("in commit: " + var14_15);
                        }
                    }
                }
                if (repo.isPushChanges()) {
                    v1 = branch = version != null ? version.getName() : null;
                    if (StringUtils.isBlank((CharSequence)branch)) {
                        branch = git.getRepository().getBranch();
                    }
                    refSpec = new RefSpec("refs/heads/" + branch + ":" + "refs/heads/" + branch);
                    this.logger.info("push changes to remote... " + refSpec);
                    pushResultList = JGitUtils.push(git, (GitScmProviderRepository)repo, refSpec);
                    for (PushResult pushResult : pushResultList) {
                        for (RemoteRefUpdate remoteRefUpdate : pushResult.getRemoteUpdates()) {
                            if (this.isSuccessStatus(remoteRefUpdate.getStatus())) continue;
                            var16_19 = new CheckInScmResult("JGit checkin", "The git-push command failed, with status: " + remoteRefUpdate.getStatus(), remoteRefUpdate.getMessage(), false);
                            break block21;
                        }
                    }
                }
                ** GOTO lbl-1000
            }
            catch (Exception e) {
                try {
                    throw new ScmException("JGit checkin failure!", (Throwable)e);
                }
                catch (Throwable var17_20) {
                    JGitUtils.closeRepo(git);
                    throw var17_20;
                }
            }
        }
        JGitUtils.closeRepo(git);
        return var16_19;
lbl-1000:
        // 1 sources

        {
            var9_10 = new CheckInScmResult("JGit checkin", checkedInFiles);
        }
        JGitUtils.closeRepo(git);
        return var9_10;
    }

    private boolean isSuccessStatus(RemoteRefUpdate.Status remoteRefUpdateStatus) {
        return remoteRefUpdateStatus == RemoteRefUpdate.Status.OK || remoteRefUpdateStatus == RemoteRefUpdate.Status.UP_TO_DATE;
    }

    private UserInfo getCommitter(ScmProviderRepository repo, Git git) {
        boolean forceMvnUser = git.getRepository().getConfig().getBoolean(GIT_MAVEN_SECTION, GIT_FORCE, false);
        UserConfig user = (UserConfig)git.getRepository().getConfig().get(UserConfig.KEY);
        String committerName = null;
        if (!forceMvnUser && !user.isCommitterNameImplicit()) {
            committerName = user.getCommitterName();
        }
        if (StringUtils.isBlank(committerName)) {
            committerName = repo.getUser();
        }
        if (StringUtils.isBlank(committerName)) {
            committerName = user.getCommitterName();
        }
        String committerMail = null;
        if (!user.isCommitterEmailImplicit()) {
            committerMail = user.getCommitterEmail();
        }
        if (StringUtils.isBlank(committerMail)) {
            String defaultDomain = git.getRepository().getConfig().getString(GIT_MAVEN_SECTION, null, GIT_MAILDOMAIN);
            defaultDomain = StringUtils.isNotBlank((CharSequence)defaultDomain) ? defaultDomain : this.getHostname();
            committerMail = StringUtils.isNotBlank((CharSequence)repo.getUser()) ? repo.getUser() + "@" + defaultDomain : user.getCommitterEmail();
        }
        return new UserInfo(committerName, committerMail);
    }

    private UserInfo getAuthor(ScmProviderRepository repo, Git git) {
        boolean forceMvnUser = git.getRepository().getConfig().getBoolean(GIT_MAVEN_SECTION, GIT_FORCE, false);
        UserConfig user = (UserConfig)git.getRepository().getConfig().get(UserConfig.KEY);
        String authorName = null;
        if (!forceMvnUser && !user.isAuthorNameImplicit()) {
            authorName = user.getAuthorName();
        }
        if (StringUtils.isBlank(authorName)) {
            authorName = repo.getUser();
        }
        if (StringUtils.isBlank(authorName)) {
            authorName = user.getAuthorName();
        }
        String authorMail = null;
        if (!user.isAuthorEmailImplicit()) {
            authorMail = user.getAuthorEmail();
        }
        if (StringUtils.isBlank(authorMail)) {
            String defaultDomain = git.getRepository().getConfig().getString(GIT_MAVEN_SECTION, null, GIT_MAILDOMAIN);
            defaultDomain = StringUtils.isNotBlank((CharSequence)defaultDomain) ? defaultDomain : this.getHostname();
            authorMail = StringUtils.isNotBlank((CharSequence)repo.getUser()) ? repo.getUser() + "@" + defaultDomain : user.getAuthorEmail();
        }
        return new UserInfo(authorName, authorMail);
    }

    private String getHostname() {
        String hostname;
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            hostname = localhost.getHostName();
        }
        catch (UnknownHostException e) {
            this.logger.warn("failed to resolve hostname to create mail address, defaulting to 'maven-scm-provider-jgit'");
            hostname = "maven-scm-provider-jgit";
        }
        return hostname;
    }

    private static final class UserInfo {
        final String name;
        final String email;

        UserInfo(String name, String email) {
            this.name = name;
            this.email = email;
        }
    }
}

