/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.remove;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.provider.perforce.command.AbstractPerforceConsumer;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerforceRemoveConsumer
extends AbstractPerforceConsumer
implements StreamConsumer {
    private static final String FILE_BEGIN_TOKEN = "//";
    private static final String PATTERN = "^([^#]+)#\\d+ - (.*)";
    private List<ScmFile> removals = new ArrayList<ScmFile>();
    private RE revisionRegexp;
    private boolean error = false;

    public PerforceRemoveConsumer() {
        try {
            this.revisionRegexp = new RE(PATTERN);
        }
        catch (RESyntaxException ignored) {
            ignored.printStackTrace();
        }
    }

    public List<ScmFile> getRemovals() {
        return this.removals;
    }

    public void consumeLine(String line) {
        if (line.startsWith("... ")) {
            return;
        }
        if (!line.startsWith(FILE_BEGIN_TOKEN)) {
            this.error(line);
        }
        if (!this.revisionRegexp.match(line)) {
            this.error(line);
        }
        this.removals.add(new ScmFile(this.revisionRegexp.getParen(1), ScmFileStatus.DELETED));
    }

    private void error(String line) {
        this.error = true;
        this.output.println(line);
    }

    public boolean isSuccess() {
        return !this.error;
    }
}

