/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.starteam.repository;

import org.apache.maven.scm.provider.ScmProviderRepository;

public class StarteamScmProviderRepository
extends ScmProviderRepository {
    private String host;
    private int port;
    private String path;

    public StarteamScmProviderRepository(String user, String password, String host, int port, String path) {
        this.setUser(user);
        this.setPassword(password);
        this.host = host;
        this.port = port;
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path must be start with a slash?");
        }
        this.path = path;
    }

    public String getUrl() {
        return this.host + ":" + this.port + this.path;
    }

    public String getFullUrl() {
        String fullUrl = this.getUser() + ":";
        if (this.getPassword() != null) {
            fullUrl = fullUrl + this.getPassword();
        }
        fullUrl = fullUrl + "@" + this.getUrl();
        return fullUrl;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public int getPort() {
        return this.port;
    }
}

