/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.export;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmRevision;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.export.AbstractExportCommand;
import org.apache.maven.scm.command.export.ExportScmResult;
import org.apache.maven.scm.command.export.ExportScmResultWithRevision;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.SvnCommandUtils;
import org.apache.maven.scm.provider.svn.SvnTagBranchUtils;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnexe.command.SvnCommandLineUtils;
import org.apache.maven.scm.provider.svn.svnexe.command.update.SvnUpdateConsumer;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class SvnExeExportCommand
extends AbstractExportCommand
implements SvnCommand {
    private final boolean interactive;

    public SvnExeExportCommand(boolean interactive) {
        this.interactive = interactive;
    }

    protected ExportScmResult executeExportCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion version, String outputDirectory) throws ScmException {
        int exitCode;
        if (outputDirectory == null) {
            outputDirectory = fileSet.getBasedir().getAbsolutePath();
        }
        SvnScmProviderRepository repository = (SvnScmProviderRepository)repo;
        String url = repository.getUrl();
        if (version != null && StringUtils.isNotEmpty((CharSequence)version.getName())) {
            if (version instanceof ScmTag) {
                url = SvnTagBranchUtils.resolveTagUrl((SvnScmProviderRepository)repository, (ScmTag)((ScmTag)version));
            } else if (version instanceof ScmBranch) {
                url = SvnTagBranchUtils.resolveBranchUrl((SvnScmProviderRepository)repository, (ScmBranch)((ScmBranch)version));
            }
        }
        url = SvnCommandUtils.fixUrl((String)url, (String)repository.getUser());
        Commandline cl = this.createCommandLine((SvnScmProviderRepository)repo, fileSet.getBasedir(), version, url, outputDirectory);
        SvnUpdateConsumer consumer = new SvnUpdateConsumer(fileSet.getBasedir());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Executing: " + SvnCommandLineUtils.cryptPassword(cl));
            if (cl.getWorkingDirectory() != null && Os.isFamily((String)"windows")) {
                this.logger.info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
            }
        }
        try {
            exitCode = SvnCommandLineUtils.execute(cl, (StreamConsumer)consumer, stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new ExportScmResult(cl.toString(), "The svn command failed.", stderr.getOutput(), false);
        }
        return new ExportScmResultWithRevision(cl.toString(), consumer.getUpdatedFiles(), String.valueOf(consumer.getRevision()));
    }

    public Commandline createCommandLine(SvnScmProviderRepository repository, File workingDirectory, ScmVersion version, String url, String outputSirectory) {
        if (version != null && StringUtils.isEmpty((CharSequence)version.getName())) {
            version = null;
        }
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine(workingDirectory, repository, this.interactive);
        cl.createArg().setValue("export");
        if (version != null && StringUtils.isNotEmpty((CharSequence)version.getName()) && version instanceof ScmRevision) {
            cl.createArg().setValue("-r");
            cl.createArg().setValue(version.getName());
        }
        cl.createArg().setValue("--force");
        cl.createArg().setValue(url + "@");
        if (outputSirectory != null && !outputSirectory.isEmpty()) {
            cl.createArg().setValue(outputSirectory + "@");
        }
        return cl;
    }
}

