/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.resolve.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.filter.resolve.FilterTransformer;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.apache.maven.shared.artifact.filter.resolve.transform.SonatypeAetherFilterTransformer;
import org.apache.maven.shared.dependency.DependencyCoordinate;
import org.apache.maven.shared.dependency.resolve.DependencyResolver;
import org.apache.maven.shared.dependency.resolve.DependencyResolverException;
import org.apache.maven.shared.dependency.resolve.internal.Invoker;
import org.apache.maven.shared.dependency.resolve.internal.Maven30ArtifactResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.artifact.ArtifactType;
import org.sonatype.aether.artifact.ArtifactTypeRegistry;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.artifact.DefaultArtifactType;

@Component(role=DependencyResolver.class, hint="maven3")
public class Maven30DependencyResolver
implements DependencyResolver {
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;

    @Override
    public Iterable<org.apache.maven.shared.artifact.resolve.ArtifactResult> resolveDependencies(ProjectBuildingRequest buildingRequest, DependencyCoordinate coordinate, TransformableFilter dependencyFilter) throws DependencyResolverException {
        ArtifactTypeRegistry typeRegistry = (ArtifactTypeRegistry)Invoker.invoke(RepositoryUtils.class, "newArtifactTypeRegistry", ArtifactHandlerManager.class, (Object)this.artifactHandlerManager);
        Dependency aetherRoot = Maven30DependencyResolver.toDependency(coordinate, typeRegistry);
        List aetherRepositories = (List)Invoker.invoke(RepositoryUtils.class, "toRepos", List.class, (Object)buildingRequest.getRemoteRepositories());
        CollectRequest request = new CollectRequest(aetherRoot, aetherRepositories);
        return this.resolveDependencies(buildingRequest, aetherRepositories, dependencyFilter, request);
    }

    @Override
    public Iterable<org.apache.maven.shared.artifact.resolve.ArtifactResult> resolveDependencies(ProjectBuildingRequest buildingRequest, Collection<org.apache.maven.model.Dependency> mavenDependencies, Collection<org.apache.maven.model.Dependency> managedMavenDependencies, TransformableFilter filter) throws DependencyResolverException {
        ArtifactTypeRegistry typeRegistry = (ArtifactTypeRegistry)Invoker.invoke(RepositoryUtils.class, "newArtifactTypeRegistry", ArtifactHandlerManager.class, (Object)this.artifactHandlerManager);
        Class[] argClasses = new Class[]{org.apache.maven.model.Dependency.class, ArtifactTypeRegistry.class};
        ArrayList<Dependency> aetherDependencies = new ArrayList<Dependency>(mavenDependencies.size());
        if (mavenDependencies != null) {
            aetherDependencies = new ArrayList(mavenDependencies.size());
            for (org.apache.maven.model.Dependency mavenDependency : mavenDependencies) {
                Object[] args = new Object[]{mavenDependency, typeRegistry};
                Dependency aetherDependency = (Dependency)Invoker.invoke(RepositoryUtils.class, "toDependency", argClasses, args);
                aetherDependencies.add(aetherDependency);
            }
        }
        ArrayList<Dependency> aetherManagedDependencies = null;
        if (managedMavenDependencies != null) {
            aetherManagedDependencies = new ArrayList<Dependency>(managedMavenDependencies.size());
            for (org.apache.maven.model.Dependency mavenDependency : managedMavenDependencies) {
                Object[] args = new Object[]{mavenDependency, typeRegistry};
                Dependency aetherDependency = (Dependency)Invoker.invoke(RepositoryUtils.class, "toDependency", argClasses, args);
                aetherManagedDependencies.add(aetherDependency);
            }
        }
        List aetherRepositories = (List)Invoker.invoke(RepositoryUtils.class, "toRepos", List.class, (Object)buildingRequest.getRemoteRepositories());
        CollectRequest request = new CollectRequest(aetherDependencies, aetherManagedDependencies, aetherRepositories);
        return this.resolveDependencies(buildingRequest, aetherRepositories, filter, request);
    }

    private Iterable<org.apache.maven.shared.artifact.resolve.ArtifactResult> resolveDependencies(ProjectBuildingRequest buildingRequest, List<RemoteRepository> aetherRepositories, TransformableFilter dependencyFilter, CollectRequest request) throws DependencyResolverException {
        try {
            DependencyFilter depFilter = null;
            if (dependencyFilter != null) {
                depFilter = (DependencyFilter)dependencyFilter.transform((FilterTransformer)new SonatypeAetherFilterTransformer());
            }
            RepositorySystemSession session = (RepositorySystemSession)Invoker.invoke(buildingRequest, "getRepositorySession");
            List dependencyResults = this.repositorySystem.resolveDependencies(session, request, depFilter);
            ArrayList<ArtifactRequest> artifactRequests = new ArrayList<ArtifactRequest>(dependencyResults.size());
            for (ArtifactResult artifactResult : dependencyResults) {
                artifactRequests.add(new ArtifactRequest(artifactResult.getArtifact(), aetherRepositories, null));
            }
            final List artifactResults = this.repositorySystem.resolveArtifacts(session, artifactRequests);
            return new Iterable<org.apache.maven.shared.artifact.resolve.ArtifactResult>(){

                @Override
                public Iterator<org.apache.maven.shared.artifact.resolve.ArtifactResult> iterator() {
                    ArrayList<Maven30ArtifactResult> artResults = new ArrayList<Maven30ArtifactResult>(artifactResults.size());
                    for (ArtifactResult artifactResult : artifactResults) {
                        artResults.add(new Maven30ArtifactResult(artifactResult));
                    }
                    return artResults.iterator();
                }
            };
        }
        catch (ArtifactResolutionException e) {
            throw new DependencyResolverException(e.getMessage(), (Exception)((Object)e));
        }
        catch (DependencyCollectionException e) {
            throw new DependencyResolverException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private static Dependency toDependency(DependencyCoordinate coordinate, ArtifactTypeRegistry stereotypes) {
        ArtifactType stereotype = stereotypes.get(coordinate.getType());
        if (stereotype == null) {
            stereotype = new DefaultArtifactType(coordinate.getType());
        }
        DefaultArtifact artifact = new DefaultArtifact(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getClassifier(), null, coordinate.getVersion(), null, stereotype);
        return new Dependency((Artifact)artifact, null);
    }
}

