/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jarsigner;

import java.io.File;
import org.apache.maven.shared.jarsigner.CommandLineConfigurationException;
import org.apache.maven.shared.jarsigner.JarSignerRequest;
import org.apache.maven.shared.jarsigner.JarSignerSignRequest;
import org.apache.maven.shared.jarsigner.JarSignerVerifyRequest;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.cli.Arg;
import org.apache.maven.shared.utils.cli.Commandline;
import org.slf4j.Logger;

public class JarSignerCommandLineBuilder {
    private String jarSignerFile;

    public Commandline build(JarSignerRequest request) throws CommandLineConfigurationException {
        String[] arguments;
        String maxMemory;
        String providerArg;
        String providerClass;
        String providerName;
        String storetype;
        String storepass;
        String keystore;
        this.checkRequiredState();
        Commandline cli = new Commandline();
        cli.setExecutable(this.jarSignerFile);
        cli.setWorkingDirectory(request.getWorkingDirectory());
        if (request.isVerbose()) {
            cli.createArg().setValue("-verbose");
        }
        if ((keystore = request.getKeystore()) != null && !keystore.isEmpty()) {
            cli.createArg().setValue("-keystore");
            cli.createArg().setValue(keystore);
        }
        if ((storepass = request.getStorepass()) != null && !storepass.isEmpty()) {
            cli.createArg().setValue("-storepass");
            Arg arg = cli.createArg();
            arg.setValue(storepass);
            arg.setMask(true);
        }
        if ((storetype = request.getStoretype()) != null && !storetype.isEmpty()) {
            cli.createArg().setValue("-storetype");
            cli.createArg().setValue(storetype);
        }
        if ((providerName = request.getProviderName()) != null && !providerName.isEmpty()) {
            cli.createArg().setValue("-providerName");
            cli.createArg().setValue(providerName);
        }
        if ((providerClass = request.getProviderClass()) != null && !providerClass.isEmpty()) {
            cli.createArg().setValue("-providerClass");
            cli.createArg().setValue(providerClass);
        }
        if ((providerArg = request.getProviderArg()) != null && !providerArg.isEmpty()) {
            cli.createArg().setValue("-providerArg");
            cli.createArg().setValue(providerArg);
        }
        if (request.isProtectedAuthenticationPath()) {
            cli.createArg().setValue("-protected");
        }
        if ((maxMemory = request.getMaxMemory()) != null && !maxMemory.isEmpty()) {
            cli.createArg().setValue("-J-Xmx" + maxMemory);
        }
        if ((arguments = request.getArguments()) != null) {
            cli.addArguments(arguments);
        }
        if (request instanceof JarSignerSignRequest) {
            this.build((JarSignerSignRequest)request, cli);
        }
        if (request instanceof JarSignerVerifyRequest) {
            this.build((JarSignerVerifyRequest)request, cli);
        }
        cli.createArg().setFile(request.getArchive());
        String alias = request.getAlias();
        if (alias != null && !alias.isEmpty()) {
            cli.createArg().setValue(alias);
        }
        return cli;
    }

    @Deprecated
    public void setLogger(Logger logger) {
    }

    public void setJarSignerFile(String jarSignerFile) {
        this.jarSignerFile = jarSignerFile;
    }

    protected void checkRequiredState() throws CommandLineConfigurationException {
        if (this.jarSignerFile == null) {
            throw new CommandLineConfigurationException("A jarSigner file is required.");
        }
    }

    protected void build(JarSignerSignRequest request, Commandline cli) {
        File certchain;
        File signedjar;
        String tsadigestalg;
        String tsapolicyid;
        String tsaAlias;
        String tsaLocation;
        String sigfile;
        String keypass = request.getKeypass();
        if (keypass != null && !keypass.isEmpty()) {
            cli.createArg().setValue("-keypass");
            Arg arg = cli.createArg();
            arg.setValue(keypass);
            arg.setMask(true);
        }
        if ((sigfile = request.getSigfile()) != null && !sigfile.isEmpty()) {
            cli.createArg().setValue("-sigfile");
            cli.createArg().setValue(sigfile);
        }
        if (StringUtils.isNotBlank((String)(tsaLocation = request.getTsaLocation()))) {
            cli.createArg().setValue("-tsa");
            cli.createArg().setValue(tsaLocation);
        }
        if (StringUtils.isNotBlank((String)(tsaAlias = request.getTsaAlias()))) {
            cli.createArg().setValue("-tsacert");
            cli.createArg().setValue(tsaAlias);
        }
        if (StringUtils.isNotBlank((String)(tsapolicyid = request.getTsapolicyid()))) {
            cli.createArg().setValue("-tsapolicyid");
            cli.createArg().setValue(tsapolicyid);
        }
        if (StringUtils.isNotBlank((String)(tsadigestalg = request.getTsadigestalg()))) {
            cli.createArg().setValue("-tsadigestalg");
            cli.createArg().setValue(tsadigestalg);
        }
        if ((signedjar = request.getSignedjar()) != null) {
            cli.createArg().setValue("-signedjar");
            cli.createArg().setValue(signedjar.getAbsolutePath());
        }
        if ((certchain = request.getCertchain()) != null) {
            cli.createArg().setValue("-certchain");
            cli.createArg().setValue(certchain.getAbsolutePath());
        }
    }

    protected void build(JarSignerVerifyRequest request, Commandline cli) {
        cli.createArg(true).setValue("-verify");
        if (request.isCerts()) {
            cli.createArg().setValue("-certs");
        }
    }
}

