/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.surefire.booter.KeyValueSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurefireProperties
extends Properties
implements KeyValueSource {
    private final LinkedHashSet<Object> items = new LinkedHashSet();

    public SurefireProperties() {
    }

    public SurefireProperties(Properties source) {
        if (source != null) {
            this.putAll((Map<?, ?>)source);
        }
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        this.items.add(key);
        return super.put(key, value);
    }

    @Override
    public synchronized Object remove(Object key) {
        this.items.remove(key);
        return super.remove(key);
    }

    @Override
    public synchronized void clear() {
        this.items.clear();
        super.clear();
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        return Collections.enumeration(this.items);
    }

    public void copyProperties(Properties source) {
        if (source != null) {
            for (Object key : source.keySet()) {
                Object value = source.get(key);
                this.put(key, value);
            }
        }
    }

    private Iterable<Object> getStringKeySet() {
        return this.keySet();
    }

    public void showToLog(Log log, String setting) {
        for (Object key : this.getStringKeySet()) {
            String value = this.getProperty((String)key);
            log.debug((CharSequence)("Setting " + setting + " [" + key + "]=[" + value + "]"));
        }
    }

    public void verifyLegalSystemProperties(Log log) {
        for (Object key : this.getStringKeySet()) {
            if (!"java.library.path".equals(key)) continue;
            log.warn((CharSequence)"java.library.path cannot be set as system property, use <argLine>-Djava.library.path=...<argLine> instead");
        }
    }

    public void copyToSystemProperties() {
        for (Object e : this.items) {
            String key = (String)e;
            String value = this.getProperty(key);
            System.setProperty(key, value);
        }
    }

    static SurefireProperties calculateEffectiveProperties(Properties systemProperties, File systemPropertiesFile, Map<String, String> systemPropertyVariables, Properties userProperties, Log log) {
        SurefireProperties result = new SurefireProperties();
        result.copyProperties(systemProperties);
        if (systemPropertiesFile != null) {
            SurefireProperties props = new SurefireProperties();
            try {
                FileInputStream fis = new FileInputStream(systemPropertiesFile);
                props.load(fis);
                ((InputStream)fis).close();
            }
            catch (IOException e) {
                String msg = "The system property file '" + systemPropertiesFile.getAbsolutePath() + "' can't be read.";
                if (log.isDebugEnabled()) {
                    log.warn((CharSequence)msg, (Throwable)e);
                }
                log.warn((CharSequence)msg);
            }
            result.copyProperties(props);
        }
        SurefireProperties.copyProperties(result, systemPropertyVariables);
        SurefireProperties.copyProperties(result, systemPropertyVariables);
        result.copyProperties(userProperties);
        return result;
    }

    public static void copyProperties(Properties target, Map<String, String> source) {
        if (source != null) {
            for (String key : source.keySet()) {
                String value = source.get(key);
                if (value == null) continue;
                target.setProperty(key, value);
            }
        }
    }

    public void copyTo(Map target) {
        for (Object key : this.keySet()) {
            target.put(key, this.get(key));
        }
    }
}

