/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.BufferedOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import org.apache.maven.plugin.surefire.report.TestSetStats;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleReporter {
    public static final String BRIEF = "brief";
    public static final String PLAIN = "plain";
    private static final String TEST_SET_STARTING_PREFIX = "Running ";
    private static final String TEST_SET_STARTING_GROUP_PREFIX = " (of ";
    private static final String TEST_SET_STARTING_GROUP_SUFIX = ")";
    private static final int BUFFER_SIZE = 4096;
    private static final PrintStream ORIGINAL_SYSTEM_OUT = System.out;
    private final PrintWriter writer = ConsoleReporter.getPrintWriter();

    private static PrintWriter getPrintWriter() {
        return new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(ORIGINAL_SYSTEM_OUT, 4096)));
    }

    public void testSetStarting(ReportEntry report) throws ReporterException {
        this.writeMessage(ConsoleReporter.getTestSetStartingMessage(report));
    }

    public void writeMessage(String message) {
        if (this.writer != null) {
            this.writer.print(message);
            this.writer.flush();
        }
    }

    public void writeLnMessage(String message) {
        if (this.writer != null) {
            this.writer.println(message);
            this.writer.flush();
        }
    }

    public void testSetCompleted(WrappedReportEntry report, TestSetStats testSetStats, List<String> testResults) throws ReporterException {
        this.writeMessage(testSetStats.getTestSetSummary(report));
        if (testResults != null) {
            for (String testResult : testResults) {
                this.writeLnMessage(testResult);
            }
        }
    }

    public void reset() {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    static String getTestSetStartingMessage(ReportEntry report) {
        StringBuilder message = new StringBuilder();
        message.append(TEST_SET_STARTING_PREFIX);
        message.append(report.getName());
        if (report.getGroup() != null && !report.getName().equals(report.getGroup())) {
            message.append(TEST_SET_STARTING_GROUP_PREFIX);
            message.append(report.getGroup());
            message.append(TEST_SET_STARTING_GROUP_SUFIX);
        }
        message.append("\n");
        return message.toString();
    }
}

