/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.maven.plugin.surefire.report.TestSetStats;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.suite.RunResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunStatistics {
    private final Sources errorSources = new Sources();
    private final Sources failureSources = new Sources();
    private int completedCount;
    private int errors;
    private int failures;
    private int skipped;

    public void addErrorSource(StackTraceWriter stackTraceWriter) {
        if (stackTraceWriter == null) {
            throw new IllegalArgumentException("Cant be null");
        }
        this.errorSources.addSource(stackTraceWriter);
    }

    public void addFailureSource(StackTraceWriter stackTraceWriter) {
        if (stackTraceWriter == null) {
            throw new IllegalArgumentException("Cant be null");
        }
        this.failureSources.addSource(stackTraceWriter);
    }

    public Collection<String> getErrorSources() {
        return this.errorSources.getListOfSources();
    }

    public Collection<String> getFailureSources() {
        return this.failureSources.getListOfSources();
    }

    public synchronized boolean hadFailures() {
        return this.failures > 0;
    }

    public synchronized boolean hadErrors() {
        return this.errors > 0;
    }

    public synchronized int getCompletedCount() {
        return this.completedCount;
    }

    public synchronized int getSkipped() {
        return this.skipped;
    }

    public synchronized void add(TestSetStats testSetStats) {
        this.completedCount += testSetStats.getCompletedCount();
        this.errors += testSetStats.getErrors();
        this.failures += testSetStats.getFailures();
        this.skipped += testSetStats.getSkipped();
    }

    public synchronized RunResult getRunResult() {
        return new RunResult(this.completedCount, this.errors, this.failures, this.skipped);
    }

    public synchronized String getSummary() {
        return "Tests run: " + this.completedCount + ", Failures: " + this.failures + ", Errors: " + this.errors + ", Skipped: " + this.skipped;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Sources {
        private final Collection<String> listOfSources = new ArrayList<String>();

        private Sources() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addSource(String source) {
            Collection<String> collection = this.listOfSources;
            synchronized (collection) {
                this.listOfSources.add(source);
            }
        }

        void addSource(StackTraceWriter stackTraceWriter) {
            this.addSource(stackTraceWriter.smartTrimmedStackTrace());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Collection<String> getListOfSources() {
            Collection<String> collection = this.listOfSources;
            synchronized (collection) {
                return Collections.unmodifiableCollection(this.listOfSources);
            }
        }
    }
}

