/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.shared.utils.logging.MessageBuilder;
import org.apache.maven.surefire.shared.utils.logging.MessageUtils;

public class TestSetStats {
    private static final String TESTS = "Tests ";
    private static final String RUN = "run: ";
    private static final String TESTS_RUN = "Tests run: ";
    private static final String FAILURES = "Failures: ";
    private static final String ERRORS = "Errors: ";
    private static final String SKIPPED = "Skipped: ";
    private static final String FAILURE_MARKER = " <<< FAILURE!";
    private static final String IN_MARKER = " - in ";
    private static final String COMMA = ", ";
    private final Queue<WrappedReportEntry> reportEntries = new ConcurrentLinkedQueue<WrappedReportEntry>();
    private final boolean trimStackTrace;
    private final boolean plainFormat;
    private long testSetStartAt;
    private long testStartAt;
    private int completedCount;
    private int errors;
    private int failures;
    private int skipped;
    private long lastStartAt;

    public TestSetStats(boolean trimStackTrace, boolean plainFormat) {
        this.trimStackTrace = trimStackTrace;
        this.plainFormat = plainFormat;
    }

    public int getElapsedSinceTestSetStart() {
        return this.testSetStartAt > 0L ? (int)(System.currentTimeMillis() - this.testSetStartAt) : 0;
    }

    public int getElapsedSinceLastStart() {
        return this.lastStartAt > 0L ? (int)(System.currentTimeMillis() - this.lastStartAt) : 0;
    }

    public void testSetStart() {
        this.lastStartAt = this.testSetStartAt = System.currentTimeMillis();
    }

    public void testStart() {
        this.lastStartAt = this.testStartAt = System.currentTimeMillis();
    }

    private void finishTest(WrappedReportEntry reportEntry) {
        this.reportEntries.add(reportEntry);
        this.incrementCompletedCount();
        if (this.testStartAt == 0L) {
            this.testStartAt = System.currentTimeMillis();
        }
    }

    public void testSucceeded(WrappedReportEntry reportEntry) {
        this.finishTest(reportEntry);
    }

    public void testError(WrappedReportEntry reportEntry) {
        ++this.errors;
        this.finishTest(reportEntry);
    }

    public void testFailure(WrappedReportEntry reportEntry) {
        ++this.failures;
        this.finishTest(reportEntry);
    }

    public void testSkipped(WrappedReportEntry reportEntry) {
        ++this.skipped;
        this.finishTest(reportEntry);
    }

    public void reset() {
        this.completedCount = 0;
        this.errors = 0;
        this.failures = 0;
        this.skipped = 0;
        for (WrappedReportEntry entry : this.reportEntries) {
            entry.getStdout().free();
            entry.getStdErr().free();
        }
        this.reportEntries.clear();
    }

    public int getCompletedCount() {
        return this.completedCount;
    }

    public int getErrors() {
        return this.errors;
    }

    public int getFailures() {
        return this.failures;
    }

    public int getSkipped() {
        return this.skipped;
    }

    private void incrementCompletedCount() {
        ++this.completedCount;
    }

    public String getTestSetSummary(WrappedReportEntry reportEntry, boolean phrasedClassName) {
        String summary = TESTS_RUN + this.completedCount + COMMA + FAILURES + this.failures + COMMA + ERRORS + this.errors + COMMA + SKIPPED + this.skipped + COMMA + reportEntry.getElapsedTimeVerbose();
        if (this.failures > 0 || this.errors > 0) {
            summary = summary + FAILURE_MARKER;
        }
        summary = summary + IN_MARKER;
        summary = summary + (phrasedClassName ? reportEntry.getReportNameWithGroup() : reportEntry.getNameWithGroup());
        return summary;
    }

    public String getColoredTestSetSummary(WrappedReportEntry reportEntry, boolean phrasedClassName) {
        boolean isSuccessful = this.failures == 0 && this.errors == 0 && this.skipped == 0;
        boolean isFailure = this.failures > 0;
        boolean isError = this.errors > 0;
        boolean isFailureOrError = isFailure | isError;
        boolean isSkipped = this.skipped > 0;
        MessageBuilder builder = MessageUtils.buffer();
        if (isSuccessful) {
            if (this.completedCount == 0) {
                builder.strong((Object)TESTS_RUN).strong((Object)this.completedCount);
            } else {
                builder.success((Object)TESTS_RUN).success((Object)this.completedCount);
            }
        } else if (isFailureOrError) {
            builder.failure((Object)TESTS).strong((Object)RUN).strong((Object)this.completedCount);
        } else {
            builder.warning((Object)TESTS).strong((Object)RUN).strong((Object)this.completedCount);
        }
        builder.a((CharSequence)COMMA);
        if (isFailure) {
            builder.failure((Object)FAILURES).failure((Object)this.failures);
        } else {
            builder.a((CharSequence)FAILURES).a((Object)this.failures);
        }
        builder.a((CharSequence)COMMA);
        if (isError) {
            builder.failure((Object)ERRORS).failure((Object)this.errors);
        } else {
            builder.a((CharSequence)ERRORS).a((Object)this.errors);
        }
        builder.a((CharSequence)COMMA);
        if (isSkipped) {
            builder.warning((Object)SKIPPED).warning((Object)this.skipped);
        } else {
            builder.a((CharSequence)SKIPPED).a((Object)this.skipped);
        }
        builder.a((CharSequence)COMMA).a((CharSequence)reportEntry.getElapsedTimeVerbose());
        if (isFailureOrError) {
            builder.failure((Object)FAILURE_MARKER);
        }
        builder.a((CharSequence)IN_MARKER);
        return TestSetStats.concatenateWithTestGroup(builder, (ReportEntry)reportEntry, phrasedClassName);
    }

    public List<String> getTestResults() {
        ArrayList<String> result = new ArrayList<String>();
        for (WrappedReportEntry testResult : this.reportEntries) {
            if (testResult.isErrorOrFailure()) {
                result.add(testResult.getOutput(this.trimStackTrace));
                continue;
            }
            if (this.plainFormat && testResult.isSkipped()) {
                result.add(testResult.getSourceName() + " skipped");
                continue;
            }
            if (!this.plainFormat || !testResult.isSucceeded()) continue;
            result.add(testResult.getElapsedTimeSummary());
        }
        return result;
    }

    public Collection<WrappedReportEntry> getReportEntries() {
        return this.reportEntries;
    }

    static String concatenateWithTestGroup(MessageBuilder builder, ReportEntry report, boolean phrasedClassName) {
        String testClass;
        if (phrasedClassName && report.getReportNameWithGroup() != null) {
            return builder.strong((Object)report.getReportNameWithGroup()).toString();
        }
        int indexOfGroup = (testClass = report.getNameWithGroup()).indexOf(" (of ");
        int delimiter = testClass.lastIndexOf(46, indexOfGroup == -1 ? testClass.length() : indexOfGroup);
        String pkg = testClass.substring(0, 1 + delimiter);
        String cls = testClass.substring(1 + delimiter);
        return builder.a((CharSequence)pkg).strong((Object)cls).toString();
    }
}

