/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.Reporter;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.StackTraceWriter;

public abstract class AbstractReporter
implements Reporter {
    protected int completedCount;
    protected int errors;
    private Collection errorSources = new ArrayList();
    protected int failures;
    private Collection failureSources = new ArrayList();
    protected long startTime;
    protected long endTime;
    private NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
    protected static final String NL = System.getProperty("line.separator");
    private static final int MS_PER_SEC = 1000;
    protected long testSetStartTime;
    protected int skipped;
    private boolean trimStackTrace;

    protected AbstractReporter(Boolean trimStackTrace) {
        this.trimStackTrace = trimStackTrace;
    }

    public void writeFooter(String footer) {
        this.writeMessage(footer);
    }

    public void runStarting(int testCount) {
        int i = 10;
    }

    public void runCompleted() {
    }

    public void runStopped() {
    }

    public void runAborted(ReportEntry report) {
    }

    public void testSetStarting(ReportEntry report) throws ReporterException {
        this.testSetStartTime = System.currentTimeMillis();
    }

    public void testSetCompleted(ReportEntry report) throws ReporterException {
    }

    public void testSetAborted(ReportEntry report) {
    }

    public Collection getFailureSources() {
        return this.failureSources;
    }

    public Collection getErrorSources() {
        return this.errorSources;
    }

    public void testStarting(ReportEntry report) {
        this.startTime = System.currentTimeMillis();
    }

    public void testSucceeded(ReportEntry report) {
        this.endTest();
    }

    public void testSkipped(ReportEntry report) {
        ++this.skipped;
        this.endTest();
    }

    public void testError(ReportEntry report, String stdOut, String stdErr) {
        ++this.errors;
        this.errorSources.add(report.getName());
        this.endTest();
    }

    public void testFailed(ReportEntry report, String stdOut, String stdErr) {
        ++this.failures;
        this.failureSources.add(report.getName());
        this.endTest();
    }

    private void endTest() {
        ++this.completedCount;
        this.endTime = System.currentTimeMillis();
        if (this.startTime == 0L) {
            this.startTime = this.endTime;
        }
    }

    public int getNumErrors() {
        return this.errors;
    }

    public int getNumSkipped() {
        return this.skipped;
    }

    public int getNumFailures() {
        return this.failures;
    }

    public int getNumTests() {
        return this.completedCount;
    }

    public void reset() {
        this.errors = 0;
        this.skipped = 0;
        this.failures = 0;
        this.completedCount = 0;
        this.failureSources = new ArrayList();
        this.errorSources = new ArrayList();
    }

    protected String elapsedTimeAsString(long runTime) {
        return this.numberFormat.format((double)runTime / 1000.0);
    }

    protected String getStackTrace(ReportEntry report) {
        StackTraceWriter writer = report.getStackTraceWriter();
        if (writer == null) {
            return null;
        }
        return this.trimStackTrace ? writer.writeTrimmedTraceToString() : writer.writeTraceToString();
    }
}

