/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.BufferedOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.maven.surefire.report.AbstractTextReporter;
import org.apache.maven.surefire.report.DefaultReportEntry;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.RunReporter;

public abstract class AbstractConsoleReporter
extends AbstractTextReporter
implements RunReporter {
    private static final String TEST_SET_STARTING_PREFIX = "Running ";
    private static final String TEST_SET_STARTING_GROUP_PREFIX = " (of ";
    private static final String TEST_SET_STARTING_GROUP_SUFIX = ")";
    protected static final int BUFFER_SIZE = 4096;
    private static final PrintStream ORIGINAL_SYSTEM_OUT = System.out;

    protected AbstractConsoleReporter(String format, ReporterConfiguration reporterConfiguration) {
        super(new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(ORIGINAL_SYSTEM_OUT, 4096))), format, reporterConfiguration);
    }

    public void testSetStarting(ReportEntry report) throws ReporterException {
        super.testSetStarting(report);
        this.writeMessage(AbstractConsoleReporter.getTestSetStartingMessage(report));
    }

    public void runStarting() {
        this.writeHeading("");
        this.writeHeading("-------------------------------------------------------");
        this.writeHeading(" T E S T S");
        this.writeHeading("-------------------------------------------------------");
    }

    public void writeHeading(String message) {
        this.writer.println(message);
        this.writer.flush();
    }

    public static String getTestSetStartingMessage(ReportEntry report) {
        StringBuffer message = new StringBuffer();
        message.append(TEST_SET_STARTING_PREFIX);
        message.append(report.getName());
        if (report.getGroup() != null && !report.getName().equals(report.getGroup())) {
            message.append(TEST_SET_STARTING_GROUP_PREFIX);
            message.append(report.getGroup());
            message.append(TEST_SET_STARTING_GROUP_SUFIX);
        }
        return message.toString();
    }

    public static ReportEntry parseTestSetStartingMessage(String message) {
        String group = null;
        int i = message.indexOf(TEST_SET_STARTING_GROUP_PREFIX);
        if (i >= 0) {
            int j = message.indexOf(TEST_SET_STARTING_GROUP_SUFIX);
            if (j <= 0) {
                throw new RuntimeException("Message provided can not be parsed");
            }
            group = message.substring(i + TEST_SET_STARTING_GROUP_PREFIX.length(), j);
        } else {
            i = message.length();
            if (i <= 0) {
                throw new RuntimeException("Message provided can not be parsed");
            }
        }
        String name = message.substring(TEST_SET_STARTING_PREFIX.length(), i);
        return DefaultReportEntry.nameGroup(name, group);
    }

    public static boolean isTestSetStartingMessage(String message) {
        return message.startsWith(TEST_SET_STARTING_PREFIX);
    }
}

