/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.maven.surefire.report.AbstractTextReporter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;

public abstract class AbstractFileReporter
extends AbstractTextReporter {
    private final File reportsDirectory;
    private final boolean deleteOnStarting;

    AbstractFileReporter(boolean trimStackTrace, String format, File reportsDirectory) {
        super(trimStackTrace, format);
        this.reportsDirectory = reportsDirectory;
        this.deleteOnStarting = false;
    }

    public void testSetStarting(ReportEntry report) throws ReporterException {
        super.testSetStarting(report);
        File reportFile = this.getReportFile(report);
        File reportDir = reportFile.getParentFile();
        reportDir.mkdirs();
        if (this.deleteOnStarting && reportFile.exists()) {
            reportFile.delete();
        }
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(reportFile));
            writer.println("-------------------------------------------------------------------------------");
            writer.println("Test set: " + report.getName());
            writer.println("-------------------------------------------------------------------------------");
            this.setWriter(writer);
        }
        catch (IOException e) {
            throw new ReporterException("Unable to create file for report: " + e.getMessage(), e);
        }
    }

    private File getReportFile(ReportEntry report) {
        return new File(this.reportsDirectory, report.getName() + ".txt");
    }

    public void testSetCompleted(ReportEntry report) throws ReporterException {
        super.testSetCompleted(report);
        this.writer.flush();
        this.writer.close();
        this.writer = null;
    }
}

