/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import org.apache.maven.surefire.util.internal.DumpFileUtils;

public final class DumpErrorSingleton {
    public static final String DUMP_FILE_EXT = ".dump";
    public static final String DUMPSTREAM_FILE_EXT = ".dumpstream";
    private static final DumpErrorSingleton SINGLETON = new DumpErrorSingleton();
    private File dumpFile;
    private File dumpStreamFile;

    private DumpErrorSingleton() {
    }

    public static DumpErrorSingleton getSingleton() {
        return SINGLETON;
    }

    public synchronized void init(File reportsDir, String dumpFileName) {
        this.dumpFile = this.createDumpFile(reportsDir, dumpFileName);
        this.dumpStreamFile = this.createDumpStreamFile(reportsDir, dumpFileName);
    }

    public synchronized void dumpException(Throwable t, String msg) {
        DumpFileUtils.dumpException(t, msg == null ? "null" : msg, this.dumpFile);
    }

    public synchronized void dumpException(Throwable t) {
        DumpFileUtils.dumpException(t, this.dumpFile);
    }

    public synchronized void dumpText(String msg) {
        DumpFileUtils.dumpText(msg == null ? "null" : msg, this.dumpFile);
    }

    public synchronized void dumpStreamException(Throwable t, String msg) {
        DumpFileUtils.dumpException(t, msg == null ? "null" : msg, this.dumpStreamFile);
    }

    public synchronized void dumpStreamException(Throwable t) {
        DumpFileUtils.dumpException(t, this.dumpStreamFile);
    }

    public synchronized void dumpStreamText(String msg) {
        DumpFileUtils.dumpText(msg == null ? "null" : msg, this.dumpStreamFile);
    }

    private File createDumpFile(File reportsDir, String dumpFileName) {
        return DumpFileUtils.newDumpFile(reportsDir, dumpFileName + DUMP_FILE_EXT);
    }

    private File createDumpStreamFile(File reportsDir, String dumpFileName) {
        return DumpFileUtils.newDumpFile(reportsDir, dumpFileName + DUMPSTREAM_FILE_EXT);
    }
}

