/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.surefire.util.UrlUtils;

public class Classpath {
    private final List elements;
    private final Set elementSet;

    public Classpath() {
        this(new ArrayList());
    }

    private Classpath(List elements) {
        this.elements = elements;
        this.elementSet = new HashSet(elements);
        if (elements.size() != this.elementSet.size()) {
            throw new IllegalStateException("This is not permitted and is a violation of contract");
        }
    }

    public List getClassPath() {
        return this.elements;
    }

    public Classpath append(Classpath otherClassPathToAppend) {
        int additionalLength = otherClassPathToAppend != null ? otherClassPathToAppend.size() : 0;
        ArrayList<String> combinedClassPath = new ArrayList<String>(this.elements.size() + additionalLength);
        combinedClassPath.addAll(this.elements);
        if (otherClassPathToAppend != null) {
            Iterator iterator = otherClassPathToAppend.getClassPath().iterator();
            while (iterator.hasNext()) {
                String element = (String)iterator.next();
                if (this.elementSet.contains(element)) continue;
                combinedClassPath.add(element);
            }
        }
        return new Classpath(combinedClassPath);
    }

    public void addClassPathElementUrl(String path) {
        if (!this.elementSet.contains(path)) {
            this.elements.add(path);
            this.elementSet.add(path);
        }
    }

    public Object get(int index) {
        return this.elements.get(index);
    }

    public int size() {
        return this.elements.size();
    }

    public String getClassPathAsString() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.elements.iterator();
        while (i.hasNext()) {
            sb.append((String)i.next()).append(File.pathSeparatorChar);
        }
        return sb.toString();
    }

    public List getAsUrlList() throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Iterator i = this.elements.iterator();
        while (i.hasNext()) {
            String url = (String)i.next();
            if (url == null) continue;
            File f = new File(url);
            urls.add(UrlUtils.getURL((File)f));
        }
        return urls;
    }

    public void setForkProperties(Properties properties, String prefix) {
        for (int i = 0; i < this.elements.size(); ++i) {
            String url = (String)this.elements.get(i);
            properties.setProperty(prefix + i, url);
        }
    }

    public void setAsSystemProperty(String propertyName) {
        System.setProperty(propertyName, this.getClassPathAsString());
    }
}

