/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.maven.surefire.booter.IsolatedClassLoader;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.booter.SystemUtils;

public final class Classpath
implements Iterable<String>,
Cloneable {
    private final List<String> unmodifiableElements;

    public static Classpath join(Classpath firstClasspath, Classpath secondClasspath) {
        LinkedHashSet<String> accumulated = new LinkedHashSet<String>();
        if (firstClasspath != null) {
            firstClasspath.addTo(accumulated);
        }
        if (secondClasspath != null) {
            secondClasspath.addTo(accumulated);
        }
        return new Classpath(accumulated);
    }

    private void addTo(@Nonnull Collection<String> c) {
        c.addAll(this.unmodifiableElements);
    }

    private Classpath() {
        this.unmodifiableElements = Collections.emptyList();
    }

    public Classpath(@Nonnull Classpath other, @Nonnull String additionalElement) {
        ArrayList<String> elems = new ArrayList<String>(other.unmodifiableElements);
        elems.add(additionalElement);
        this.unmodifiableElements = Collections.unmodifiableList(elems);
    }

    public Classpath(@Nonnull Collection<String> elements) {
        ArrayList<String> newCp = new ArrayList<String>(elements.size());
        for (String element : elements) {
            if ((element = element.trim()).isEmpty()) continue;
            newCp.add(element);
        }
        this.unmodifiableElements = Collections.unmodifiableList(newCp);
    }

    public static Classpath emptyClasspath() {
        return new Classpath();
    }

    public Classpath addClassPathElementUrl(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Null is not a valid class path element url.");
        }
        return this.unmodifiableElements.contains(path) ? this : new Classpath(this, path);
    }

    @Nonnull
    public List<String> getClassPath() {
        return this.unmodifiableElements;
    }

    public void writeToSystemProperty(@Nonnull String propertyName) {
        StringBuilder sb = new StringBuilder();
        for (String element : this.unmodifiableElements) {
            sb.append(element).append(File.pathSeparatorChar);
        }
        System.setProperty(propertyName, sb.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Classpath classpath = (Classpath)o;
        return this.unmodifiableElements.equals(classpath.unmodifiableElements);
    }

    public ClassLoader createClassLoader(boolean childDelegation, boolean enableAssertions, @Nonnull String roleName) throws SurefireExecutionException {
        try {
            ClassLoader parent = SystemUtils.platformClassLoader();
            IsolatedClassLoader classLoader = new IsolatedClassLoader(parent, childDelegation, roleName);
            for (String classPathElement : this.unmodifiableElements) {
                classLoader.addURL(new File(classPathElement).toURI().toURL());
            }
            if (parent != null) {
                parent.setDefaultAssertionStatus(enableAssertions);
            }
            classLoader.setDefaultAssertionStatus(enableAssertions);
            return classLoader;
        }
        catch (MalformedURLException e) {
            throw new SurefireExecutionException("When creating classloader", e);
        }
    }

    public int hashCode() {
        return this.unmodifiableElements.hashCode();
    }

    public String getLogMessage(@Nonnull String descriptor) {
        StringBuilder result = new StringBuilder(descriptor);
        for (String element : this.unmodifiableElements) {
            result.append("  ").append(element);
        }
        return result.toString();
    }

    public String getCompactLogMessage(@Nonnull String descriptor) {
        StringBuilder result = new StringBuilder(descriptor);
        for (String element : this.unmodifiableElements) {
            result.append("  ");
            int pos = element.lastIndexOf(File.separatorChar);
            result.append(pos == -1 ? element : element.substring(pos + 1));
        }
        return result.toString();
    }

    @Override
    public Iterator<String> iterator() {
        return this.unmodifiableElements.iterator();
    }

    public Classpath clone() {
        return new Classpath(this.unmodifiableElements);
    }
}

