/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitplatform;

import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.maven.surefire.api.provider.AbstractProvider;
import org.apache.maven.surefire.api.provider.ProviderParameters;
import org.apache.maven.surefire.api.report.ConsoleOutputCapture;
import org.apache.maven.surefire.api.report.ReporterException;
import org.apache.maven.surefire.api.report.ReporterFactory;
import org.apache.maven.surefire.api.report.RunMode;
import org.apache.maven.surefire.api.report.TestOutputReceiver;
import org.apache.maven.surefire.api.report.TestOutputReportEntry;
import org.apache.maven.surefire.api.report.TestReportListener;
import org.apache.maven.surefire.api.suite.RunResult;
import org.apache.maven.surefire.api.testset.TestListResolver;
import org.apache.maven.surefire.api.testset.TestSetFailedException;
import org.apache.maven.surefire.api.util.ScanResult;
import org.apache.maven.surefire.api.util.ScannerFilter;
import org.apache.maven.surefire.api.util.SurefireReflectionException;
import org.apache.maven.surefire.api.util.TestsToRun;
import org.apache.maven.surefire.junitplatform.LazyLauncher;
import org.apache.maven.surefire.junitplatform.RunListenerAdapter;
import org.apache.maven.surefire.junitplatform.TestMethodFilter;
import org.apache.maven.surefire.junitplatform.TestPlanScannerFilter;
import org.apache.maven.surefire.shared.utils.StringUtils;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.EngineFilter;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;

public class JUnitPlatformProvider
extends AbstractProvider {
    static final String CONFIGURATION_PARAMETERS = "configurationParameters";
    private final ProviderParameters parameters;
    private final Launcher launcher;
    private final Filter<?>[] filters;
    private final Map<String, String> configurationParameters;

    public JUnitPlatformProvider(ProviderParameters parameters) {
        this(parameters, new LazyLauncher());
    }

    JUnitPlatformProvider(ProviderParameters parameters, Launcher launcher) {
        this.parameters = parameters;
        this.launcher = launcher;
        this.filters = this.newFilters();
        this.configurationParameters = this.newConfigurationParameters();
    }

    public Iterable<Class<?>> getSuites() {
        try {
            TestsToRun testsToRun = this.scanClasspath();
            return testsToRun;
        }
        finally {
            this.closeLauncher();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunResult invoke(Object forkTestSet) throws TestSetFailedException, ReporterException {
        RunResult runResult;
        block6: {
            ReporterFactory reporterFactory = this.parameters.getReporterFactory();
            try {
                RunListenerAdapter adapter = new RunListenerAdapter((TestReportListener<TestOutputReportEntry>)reporterFactory.createTestReportListener());
                adapter.setRunMode(RunMode.NORMAL_RUN);
                ConsoleOutputCapture.startCapture((TestOutputReceiver)adapter);
                JUnitPlatformProvider.setupJunitLogger();
                if (forkTestSet instanceof TestsToRun) {
                    this.invokeAllTests((TestsToRun)forkTestSet, adapter);
                    break block6;
                }
                if (forkTestSet instanceof Class) {
                    this.invokeAllTests(TestsToRun.fromClass((Class)((Class)forkTestSet)), adapter);
                    break block6;
                }
                if (forkTestSet == null) {
                    this.invokeAllTests(this.scanClasspath(), adapter);
                    break block6;
                }
                throw new IllegalArgumentException("Unexpected value of forkTestSet: " + forkTestSet);
            }
            finally {
                runResult = reporterFactory.close();
            }
        }
        return runResult;
    }

    private static void setupJunitLogger() {
        Logger logger = Logger.getLogger("org.junit");
        if (logger.getLevel() == null) {
            logger.setLevel(Level.WARNING);
        }
    }

    private TestsToRun scanClasspath() {
        TestPlanScannerFilter filter = new TestPlanScannerFilter(this.launcher, this.filters);
        ScanResult scanResult = this.parameters.getScanResult();
        TestsToRun scannedClasses = scanResult.applyFilter((ScannerFilter)filter, this.parameters.getTestClassLoader());
        return this.parameters.getRunOrderCalculator().orderTestClasses(scannedClasses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeAllTests(TestsToRun testsToRun, RunListenerAdapter adapter) {
        try {
            this.execute(testsToRun, adapter);
        }
        finally {
            this.closeLauncher();
        }
        int count = this.parameters.getTestRequest().getRerunFailingTestsCount();
        if (count > 0 && adapter.hasFailingTests()) {
            adapter.setRunMode(RunMode.RERUN_TEST_AFTER_FAILURE);
            for (int i = 0; i < count; ++i) {
                try {
                    LauncherDiscoveryRequest discoveryRequest = this.buildLauncherDiscoveryRequestForRerunFailures(adapter);
                    adapter.reset();
                    this.launcher.execute(discoveryRequest, new TestExecutionListener[]{adapter});
                    if (adapter.hasFailingTests()) continue;
                    break;
                }
                finally {
                    this.closeLauncher();
                }
            }
        }
    }

    private void execute(TestsToRun testsToRun, RunListenerAdapter adapter) {
        TestExecutionListener[] testExecutionListeners = new TestExecutionListener[]{adapter};
        if (testsToRun.allowEagerReading()) {
            ArrayList selectors = new ArrayList();
            testsToRun.iterator().forEachRemaining(c -> selectors.add(DiscoverySelectors.selectClass((String)c.getName())));
            LauncherDiscoveryRequestBuilder builder = LauncherDiscoveryRequestBuilder.request().filters(this.filters).configurationParameters(this.configurationParameters).selectors(selectors);
            this.launcher.execute(builder.build(), testExecutionListeners);
        } else {
            testsToRun.iterator().forEachRemaining(c -> {
                LauncherDiscoveryRequestBuilder builder = LauncherDiscoveryRequestBuilder.request().filters(this.filters).configurationParameters(this.configurationParameters).selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass((String)c.getName())});
                this.launcher.execute(builder.build(), testExecutionListeners);
            });
        }
    }

    private void closeLauncher() {
        if (this.launcher instanceof AutoCloseable) {
            try {
                ((AutoCloseable)this.launcher).close();
            }
            catch (Exception e) {
                throw new SurefireReflectionException((Throwable)e);
            }
        }
    }

    private LauncherDiscoveryRequest buildLauncherDiscoveryRequestForRerunFailures(RunListenerAdapter adapter) {
        LauncherDiscoveryRequestBuilder builder = LauncherDiscoveryRequestBuilder.request().filters(this.filters).configurationParameters(this.configurationParameters);
        for (TestIdentifier identifier : new LinkedHashSet<TestIdentifier>(adapter.getFailures().keySet())) {
            builder.selectors(new DiscoverySelector[]{DiscoverySelectors.selectUniqueId((String)identifier.getUniqueId())});
        }
        return builder.build();
    }

    private Filter<?>[] newFilters() {
        ArrayList filters = new ArrayList();
        this.getPropertiesList("groups").map(TagFilter::includeTags).ifPresent(filters::add);
        this.getPropertiesList("excludegroups").map(TagFilter::excludeTags).ifPresent(filters::add);
        Optional.of(TestListResolver.optionallyWildcardFilter((TestListResolver)this.parameters.getTestRequest().getTestListResolver())).filter(f -> !f.isEmpty()).filter(f -> !f.isWildcard()).map(TestMethodFilter::new).ifPresent(filters::add);
        this.getPropertiesList("includejunit5engines").map(EngineFilter::includeEngines).ifPresent(filters::add);
        this.getPropertiesList("excludejunit5engines").map(EngineFilter::excludeEngines).ifPresent(filters::add);
        return filters.toArray(new Filter[0]);
    }

    Filter<?>[] getFilters() {
        return this.filters;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> newConfigurationParameters() {
        String content = (String)this.parameters.getProviderProperties().get(CONFIGURATION_PARAMETERS);
        if (content == null) {
            return Collections.emptyMap();
        }
        try (StringReader reader = new StringReader(content);){
            HashMap<String, String> result = new HashMap<String, String>();
            Properties props = new Properties();
            props.load(reader);
            props.stringPropertyNames().forEach(key -> result.put((String)key, props.getProperty((String)key)));
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error reading configurationParameters", e);
        }
    }

    Map<String, String> getConfigurationParameters() {
        return this.configurationParameters;
    }

    private Optional<List<String>> getPropertiesList(String key) {
        String property = (String)this.parameters.getProviderProperties().get(key);
        return StringUtils.isBlank((String)property) ? Optional.empty() : Optional.of(Arrays.stream(property.split("[,]+")).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toList()));
    }
}

