/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitplatform;

import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.surefire.api.report.OutputReportEntry;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.api.report.RunMode;
import org.apache.maven.surefire.api.report.SafeThrowable;
import org.apache.maven.surefire.api.report.SimpleReportEntry;
import org.apache.maven.surefire.api.report.StackTraceWriter;
import org.apache.maven.surefire.api.report.Stoppable;
import org.apache.maven.surefire.api.report.TestOutputReceiver;
import org.apache.maven.surefire.api.report.TestOutputReportEntry;
import org.apache.maven.surefire.api.report.TestReportListener;
import org.apache.maven.surefire.api.report.TestSetReportEntry;
import org.apache.maven.surefire.api.util.ReflectionUtils;
import org.apache.maven.surefire.api.util.internal.ObjectUtils;
import org.apache.maven.surefire.report.ClassMethodIndexer;
import org.apache.maven.surefire.report.PojoStackTraceWriter;
import org.apache.maven.surefire.report.RunModeSetter;
import org.apache.maven.surefire.shared.lang3.StringUtils;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

final class RunListenerAdapter
implements TestExecutionListener,
TestOutputReceiver<OutputReportEntry>,
RunModeSetter {
    private final ClassMethodIndexer classMethodIndexer = new ClassMethodIndexer();
    private final ConcurrentMap<TestIdentifier, Long> testStartTime = new ConcurrentHashMap<TestIdentifier, Long>();
    private final ConcurrentMap<TestIdentifier, TestExecutionResult> failures = new ConcurrentHashMap<TestIdentifier, TestExecutionResult>();
    private final ConcurrentMap<String, TestIdentifier> runningTestIdentifiersByUniqueId = new ConcurrentHashMap<String, TestIdentifier>();
    private final TestReportListener<TestOutputReportEntry> runListener;
    private final Stoppable stoppable;
    private volatile TestPlan testPlan;
    private volatile RunMode runMode;

    RunListenerAdapter(TestReportListener<TestOutputReportEntry> runListener, Stoppable stoppable) {
        this.runListener = runListener;
        this.stoppable = stoppable;
    }

    public void setRunMode(RunMode runMode) {
        this.runMode = runMode;
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.testPlan = testPlan;
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.testPlan = null;
        this.testStartTime.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void executionStarted(TestIdentifier testIdentifier) {
        this.runningTestIdentifiersByUniqueId.put(testIdentifier.getUniqueId(), testIdentifier);
        if (testIdentifier.isContainer()) {
            if (testIdentifier.getSource().filter(ClassSource.class::isInstance).isPresent()) {
                this.testStartTime.put(testIdentifier, System.currentTimeMillis());
                this.runListener.testSetStarting((TestSetReportEntry)this.createReportEntry(testIdentifier));
                return;
            }
        }
        if (!testIdentifier.isTest()) return;
        this.testStartTime.put(testIdentifier, System.currentTimeMillis());
        this.runListener.testStarting((ReportEntry)this.createReportEntry(testIdentifier));
    }

    /*
     * Unable to fully structure code
     */
    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (!testIdentifier.isContainer()) ** GOTO lbl-1000
        if (testIdentifier.getSource().filter((Predicate<TestSource>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lorg/junit/platform/engine/TestSource;)Z)(ClassSource.class)).isPresent()) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        isClass = v0;
        isTest = testIdentifier.isTest();
        failed = testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED;
        isAssertionError = testExecutionResult.getThrowable().filter((Predicate<Throwable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Ljava/lang/Throwable;)Z)(AssertionError.class)).isPresent();
        v1 = isRootContainer = testIdentifier.isContainer() != false && testIdentifier.getParentId().isPresent() == false;
        if (failed || isClass || isTest) {
            elapsed = this.computeElapsedTime(testIdentifier);
            switch (1.$SwitchMap$org$junit$platform$engine$TestExecutionResult$Status[testExecutionResult.getStatus().ordinal()]) {
                case 1: {
                    if (isTest) {
                        this.runListener.testAssumptionFailure((ReportEntry)this.createReportEntry(testIdentifier, testExecutionResult, elapsed));
                        break;
                    }
                    this.runListener.testSetCompleted((TestSetReportEntry)this.createReportEntry(testIdentifier, testExecutionResult, ObjectUtils.systemProps(), null, elapsed));
                    break;
                }
                case 2: {
                    reason = this.safeGetMessage(testExecutionResult.getThrowable().orElse(null));
                    reportEntry = this.createReportEntry(testIdentifier, testExecutionResult, reason, elapsed);
                    if (isAssertionError) {
                        this.runListener.testFailed((ReportEntry)reportEntry);
                    } else {
                        this.runListener.testError((ReportEntry)reportEntry);
                    }
                    if (isClass || isRootContainer) {
                        this.runListener.testSetCompleted((TestSetReportEntry)this.createReportEntry(testIdentifier, null, ObjectUtils.systemProps(), null, elapsed));
                    }
                    this.failures.put(testIdentifier, testExecutionResult);
                    this.fireStopEvent();
                    break;
                }
                default: {
                    if (isTest) {
                        this.runListener.testSucceeded((ReportEntry)this.createReportEntry(testIdentifier, null, elapsed));
                        break;
                    }
                    this.runListener.testSetCompleted((TestSetReportEntry)this.createReportEntry(testIdentifier, null, ObjectUtils.systemProps(), null, elapsed));
                }
            }
        }
        this.runningTestIdentifiersByUniqueId.remove(testIdentifier.getUniqueId());
    }

    private Integer computeElapsedTime(TestIdentifier testIdentifier) {
        Long startTime = (Long)this.testStartTime.remove(testIdentifier);
        long endTime = System.currentTimeMillis();
        return startTime == null ? null : Integer.valueOf((int)(endTime - startTime));
    }

    private Stream<TestIdentifier> collectAllTestIdentifiersInHierarchy(TestIdentifier testIdentifier) {
        return testIdentifier.getParentId().map(this.runningTestIdentifiersByUniqueId::get).map(parentTestIdentifier -> Stream.concat(Stream.of(parentTestIdentifier), this.collectAllTestIdentifiersInHierarchy((TestIdentifier)parentTestIdentifier))).orElseGet(Stream::empty);
    }

    private String safeGetMessage(Throwable throwable) {
        try {
            SafeThrowable t = throwable == null ? null : new SafeThrowable(throwable);
            return t == null ? null : t.getMessage();
        }
        catch (Throwable t) {
            return t.getMessage();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        if (!testIdentifier.isContainer()) ** GOTO lbl-1000
        if (testIdentifier.getSource().filter((Predicate<TestSource>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lorg/junit/platform/engine/TestSource;)Z)(ClassSource.class)).isPresent()) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        isClass = v0;
        this.testStartTime.remove(testIdentifier);
        if (isClass) {
            report = this.createReportEntry(testIdentifier);
            this.runListener.testSetStarting((TestSetReportEntry)report);
            for (TestIdentifier child : this.testPlan.getChildren(testIdentifier)) {
                this.runListener.testSkipped((ReportEntry)this.createReportEntry(child, null, Collections.emptyMap(), reason, null));
            }
            this.runListener.testSetCompleted((TestSetReportEntry)report);
        } else {
            this.runListener.testSkipped((ReportEntry)this.createReportEntry(testIdentifier, null, Collections.emptyMap(), reason, null));
        }
    }

    private SimpleReportEntry createReportEntry(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult, Map<String, String> systemProperties, String reason, Integer elapsedTime) {
        String methodText;
        String classText;
        ResultDisplay classMethodName = this.toClassMethodName(testIdentifier);
        String className = classMethodName.getClassName();
        if (Objects.equals(className, classText = classMethodName.getDisplayName())) {
            classText = null;
        }
        if (classMethodName.getClassDisplayName() != null) {
            classText = classMethodName.getClassDisplayName();
        }
        boolean failed = testExecutionResult == null || testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED;
        String methodName = failed || testIdentifier.isTest() ? classMethodName.getMethodSignature() : null;
        String string = methodText = failed || testIdentifier.isTest() ? classMethodName.getMethodDisplayName() : null;
        if (Objects.equals(methodName, methodText)) {
            methodText = null;
        }
        StackTraceWriter stw = testExecutionResult == null ? null : this.toStackTraceWriter(className, methodName, testExecutionResult);
        return new SimpleReportEntry(this.runMode, Long.valueOf(this.classMethodIndexer.indexClassMethod(className, methodName)), className, classText, methodName, methodText, stw, elapsedTime, reason, systemProperties);
    }

    private SimpleReportEntry createReportEntry(TestIdentifier testIdentifier) {
        return this.createReportEntry(testIdentifier, null, null);
    }

    private SimpleReportEntry createReportEntry(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult, Integer elapsedTime) {
        return this.createReportEntry(testIdentifier, testExecutionResult, Collections.emptyMap(), null, elapsedTime);
    }

    private SimpleReportEntry createReportEntry(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult, String reason, Integer elapsedTime) {
        return this.createReportEntry(testIdentifier, testExecutionResult, Collections.emptyMap(), reason, elapsedTime);
    }

    private StackTraceWriter toStackTraceWriter(String realClassName, String realMethodName, TestExecutionResult testExecutionResult) {
        switch (testExecutionResult.getStatus()) {
            case ABORTED: 
            case FAILED: {
                Throwable exception = testExecutionResult.getThrowable().orElse(null);
                return this.toStackTraceWriter(realClassName, realMethodName, exception);
            }
        }
        return testExecutionResult.getThrowable().map(t -> this.toStackTraceWriter(realClassName, realMethodName, (Throwable)t)).orElse(null);
    }

    private StackTraceWriter toStackTraceWriter(String realClassName, String realMethodName, Throwable throwable) {
        return new PojoStackTraceWriter(realClassName, realMethodName, throwable);
    }

    private TestIdentifier findTopParent(TestIdentifier testIdentifier) {
        if (!this.hasParentId(testIdentifier)) {
            return testIdentifier;
        }
        TestIdentifier parent = this.testPlan.getTestIdentifier(((UniqueId)testIdentifier.getParentIdObject().get()).toString());
        return !parent.getParentIdObject().isPresent() ? testIdentifier : this.findTopParent(parent);
    }

    private boolean hasParentId(TestIdentifier testIdentifier) {
        Method getParentIdObjectMethod = ReflectionUtils.tryGetMethod(testIdentifier.getClass(), (String)"getParentIdObject", (Class[])new Class[0]);
        if (getParentIdObjectMethod == null) {
            return false;
        }
        try {
            Optional uniqueIdOptional = (Optional)getParentIdObjectMethod.invoke((Object)testIdentifier, new Object[0]);
            return uniqueIdOptional.isPresent();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private TestIdentifier findFirstParentContainerAndSourceClass(TestIdentifier testIdentifier) {
        block3: {
            block2: {
                if (!this.hasParentId(testIdentifier)) break block2;
                if (!testIdentifier.isContainer()) break block3;
                if (!testIdentifier.getSource().filter(ClassSource.class::isInstance).isPresent()) break block3;
            }
            return testIdentifier;
        }
        TestIdentifier parent = this.testPlan.getTestIdentifier(((UniqueId)testIdentifier.getParentIdObject().get()).toString());
        return this.findFirstParentContainerAndSourceClass(parent);
    }

    private ResultDisplay toClassMethodName(TestIdentifier testIdentifier) {
        Optional<Object> classLevelName = Optional.empty();
        TestIdentifier parent = this.findTopParent(testIdentifier);
        if (parent != null) {
            if (parent.getSource().filter(ClassSource.class::isInstance).isPresent()) {
                ClassSource classSource = (ClassSource)parent.getSource().get();
                classLevelName = Optional.of(classSource.getClassName());
            }
        }
        String classDisplayName = null;
        if (testIdentifier.isTest()) {
            TestIdentifier parentContainer = this.findFirstParentContainerAndSourceClass(testIdentifier);
            Optional<String> parentDisplayNameTagValue = this.findDisplayNameTagValue(parentContainer);
            classDisplayName = parentDisplayNameTagValue.orElse(parentContainer.getLegacyReportingName());
        }
        Optional testSource = testIdentifier.getSource();
        String display = testIdentifier.getDisplayName();
        if (testSource.filter(MethodSource.class::isInstance).isPresent()) {
            MethodSource methodSource = testSource.map(MethodSource.class::cast).get();
            String realClassName = methodSource.getClassName();
            ResultDisplay source = this.collectAllTestIdentifiersInHierarchy(testIdentifier).filter(i -> i.getSource().map(ClassSource.class::isInstance).orElse(false)).findFirst().map(this::toClassMethodName).map(s -> new ResultDisplay(s.getClassName(), s.getDisplayName(), null, null, s.getClassDisplayName())).orElse(new ResultDisplay(realClassName, realClassName, null, null, classDisplayName));
            String parentDisplay = this.collectAllTestIdentifiersInHierarchy(testIdentifier).filter(identifier -> identifier.getSource().filter(MethodSource.class::isInstance).isPresent()).map(TestIdentifier::getDisplayName).collect(Collectors.joining(" "));
            boolean needsSpaceSeparator = StringUtils.isNotBlank((CharSequence)parentDisplay) && !display.startsWith("[");
            String methodDisplay = parentDisplay + (needsSpaceSeparator ? " " : "") + display;
            boolean isParameterized = StringUtils.isNotBlank((CharSequence)methodSource.getMethodParameterTypes());
            boolean hasParameterizedParent = this.collectAllTestIdentifiersInHierarchy(testIdentifier).filter(identifier -> !identifier.getSource().isPresent()).map(TestIdentifier::getLegacyReportingName).anyMatch(legacyReportingName -> legacyReportingName.matches("^\\[.+]$"));
            boolean isTestTemplate = testIdentifier.getLegacyReportingName().matches("^.*\\[\\d+]$");
            boolean parameterized = isParameterized || hasParameterizedParent || isTestTemplate;
            String methodName = methodSource.getMethodName();
            String description = testIdentifier.getLegacyReportingName();
            boolean equalDescriptions = methodDisplay.equals(description);
            boolean hasLegacyDescription = description.startsWith(methodName + '(');
            boolean hasDisplayName = !equalDescriptions || !hasLegacyDescription;
            String methodDesc = parameterized ? description : methodName;
            String methodDisp = hasDisplayName ? methodDisplay : methodDesc;
            return new ResultDisplay((String)classLevelName.orElse(source.getClassName()), source.getDisplayName(), methodDesc, methodDisp, classDisplayName);
        }
        if (testSource.filter(ClassSource.class::isInstance).isPresent()) {
            ClassSource classSource = testSource.map(ClassSource.class::cast).get();
            String className = classSource.getClassName();
            Optional<String> displayNameTagValue = this.findDisplayNameTagValue(testIdentifier);
            return new ResultDisplay((String)classLevelName.orElse(className), displayNameTagValue.orElse(className), null, null, classDisplayName);
        }
        String source = this.testPlan.getParent(testIdentifier).map(TestIdentifier::getDisplayName).orElse(display);
        return new ResultDisplay(classLevelName.orElse(source), source, display, display, classDisplayName);
    }

    private Optional<String> findDisplayNameTagValue(TestIdentifier testIdentifier) {
        try {
            Class<?> displayNameClazz = Thread.currentThread().getContextClassLoader().loadClass("org.junit.jupiter.api.DisplayName");
            Optional<Annotation> displayNameAnn = testIdentifier.getSource().filter(ClassSource.class::isInstance).map(s -> ((ClassSource)s).getJavaClass()).filter(m -> m.isAnnotationPresent(displayNameClazz)).map(method -> method.getAnnotation(displayNameClazz));
            Method valueMethod = displayNameClazz.getMethod("value", new Class[0]);
            return displayNameAnn.map(a -> {
                try {
                    return (String)valueMethod.invoke(a, new Object[0]);
                }
                catch (Throwable e) {
                    return null;
                }
            });
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    Map<TestIdentifier, TestExecutionResult> getFailures() {
        return this.failures;
    }

    boolean hasFailingTests() {
        return !this.getFailures().isEmpty();
    }

    void reset() {
        this.getFailures().clear();
        this.testPlan = null;
    }

    public void writeTestOutput(OutputReportEntry reportEntry) {
        Long testRunId = this.classMethodIndexer.getLocalIndex();
        this.runListener.writeTestOutput((OutputReportEntry)new TestOutputReportEntry(reportEntry, this.runMode, testRunId));
    }

    private void fireStopEvent() {
        if (this.runMode == RunMode.NORMAL_RUN) {
            this.stoppable.fireStopEvent();
        }
    }

    private static class ResultDisplay {
        private String className;
        private String displayName;
        private String methodSignature;
        private String methodDisplayName;
        private String classDisplayName;

        ResultDisplay(String className, String displayName, String methodSignature, String methodDisplayName, String classDisplayName) {
            this.className = className;
            this.displayName = displayName;
            this.methodSignature = methodSignature;
            this.methodDisplayName = methodDisplayName;
            this.classDisplayName = classDisplayName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getMethodSignature() {
            return this.methodSignature;
        }

        public String getMethodDisplayName() {
            return this.methodDisplayName;
        }

        public String getClassDisplayName() {
            return this.classDisplayName;
        }
    }
}

