/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junit;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.surefire.junit.JUnitStackTraceWriter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.report.StackTraceWriter;

public class TestListenerInvocationHandler
implements InvocationHandler {
    private static final String START_TEST = "startTest";
    private static final String ADD_FAILURE = "addFailure";
    private static final String ADD_ERROR = "addError";
    private static final String END_TEST = "endTest";
    private Set failedTestsSet = new HashSet();
    private ReporterManager reportManager;
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public TestListenerInvocationHandler(ReporterManager reportManager, Object instanceOfTestResult, ClassLoader loader) {
        if (reportManager == null) {
            throw new NullPointerException("reportManager is null");
        }
        if (instanceOfTestResult == null) {
            throw new NullPointerException("instanceOfTestResult is null");
        }
        if (loader == null) {
            throw new NullPointerException("loader is null");
        }
        this.reportManager = reportManager;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals(START_TEST)) {
            this.handleStartTest(args);
        } else if (methodName.equals(ADD_ERROR)) {
            this.handleAddError(args);
        } else if (methodName.equals(ADD_FAILURE)) {
            this.handleAddFailure(args);
        } else if (methodName.equals(END_TEST)) {
            this.handleEndTest(args);
        }
        return null;
    }

    public void handleStartTest(Object[] args) {
        ReportEntry report = new ReportEntry(args[0], args[0].toString(), args[0].getClass().getName());
        this.reportManager.testStarting(report);
    }

    private void handleAddError(Object[] args) throws IllegalAccessException, InvocationTargetException {
        ReportEntry report = new ReportEntry(args[0], args[0].toString(), args[1].toString(), (StackTraceWriter)this.getStackTraceWriter(args));
        this.reportManager.testError(report);
        this.failedTestsSet.add(new FailedTest(args[0], Thread.currentThread()));
    }

    private JUnitStackTraceWriter getStackTraceWriter(Object[] args) throws IllegalAccessException, InvocationTargetException {
        String testName;
        try {
            Method m = args[0].getClass().getMethod("getName", EMPTY_CLASS_ARRAY);
            testName = (String)m.invoke(args[0], (Object[])EMPTY_STRING_ARRAY);
        }
        catch (NoSuchMethodException e) {
            testName = "UNKNOWN";
        }
        return new JUnitStackTraceWriter(args[0].getClass().getName(), testName, (Throwable)args[1]);
    }

    private void handleAddFailure(Object[] args) throws IllegalAccessException, InvocationTargetException {
        ReportEntry report = new ReportEntry(args[0], args[0].toString(), args[1].toString(), (StackTraceWriter)this.getStackTraceWriter(args));
        this.reportManager.testFailed(report);
        this.failedTestsSet.add(new FailedTest(args[0], Thread.currentThread()));
    }

    private void handleEndTest(Object[] args) {
        boolean testHadFailed = this.failedTestsSet.remove(new FailedTest(args[0], Thread.currentThread()));
        if (!testHadFailed) {
            ReportEntry report = new ReportEntry(args[0], args[0].toString(), args[0].getClass().getName());
            this.reportManager.testSucceeded(report);
        }
    }

    private static class FailedTest {
        private Object testThatFailed;
        private Thread threadOnWhichTestFailed;

        FailedTest(Object testThatFailed, Thread threadOnWhichTestFailed) {
            if (testThatFailed == null) {
                throw new NullPointerException("testThatFailed is null");
            }
            if (threadOnWhichTestFailed == null) {
                throw new NullPointerException("threadOnWhichTestFailed is null");
            }
            this.testThatFailed = testThatFailed;
            this.threadOnWhichTestFailed = threadOnWhichTestFailed;
        }

        public boolean equals(Object obj) {
            boolean retVal = true;
            if (obj == null || this.getClass() != obj.getClass()) {
                retVal = false;
            } else {
                FailedTest ft = (FailedTest)obj;
                if (ft.testThatFailed != this.testThatFailed) {
                    retVal = false;
                } else if (!ft.threadOnWhichTestFailed.equals(this.threadOnWhichTestFailed)) {
                    retVal = false;
                }
            }
            return retVal;
        }

        public int hashCode() {
            return this.threadOnWhichTestFailed.hashCode();
        }
    }
}

