/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JUnitCoreParameters {
    public static final String PARALLEL_KEY = "parallel";
    public static final String PERCORETHREADCOUNT_KEY = "perCoreThreadCount";
    public static final String THREADCOUNT_KEY = "threadcount";
    public static final String THREADCOUNTSUITES_KEY = "threadcountsuites";
    public static final String THREADCOUNTCLASSES_KEY = "threadcountclasses";
    public static final String THREADCOUNTMETHODS_KEY = "threadcountmethods";
    public static final String USEUNLIMITEDTHREADS_KEY = "useUnlimitedThreads";
    public static final String PARALLEL_TIMEOUT_KEY = "paralleltimeout";
    public static final String PARALLEL_TIMEOUTFORCED_KEY = "paralleltimeoutforced";
    public static final String PARALLEL_OPTIMIZE_KEY = "paralleloptimization";
    private final String parallel;
    private final boolean perCoreThreadCount;
    private final int threadCount;
    private final int threadCountSuites;
    private final int threadCountClasses;
    private final int threadCountMethods;
    private final double parallelTestsTimeoutInSeconds;
    private final double parallelTestsTimeoutForcedInSeconds;
    private final boolean useUnlimitedThreads;
    private final boolean parallelOptimization;

    public JUnitCoreParameters(Map<String, String> properties) {
        this.parallel = JUnitCoreParameters.property(properties, PARALLEL_KEY, "none").toLowerCase();
        this.perCoreThreadCount = JUnitCoreParameters.property(properties, PERCORETHREADCOUNT_KEY, true);
        this.threadCount = JUnitCoreParameters.property(properties, THREADCOUNT_KEY, 0);
        this.threadCountMethods = JUnitCoreParameters.property(properties, THREADCOUNTMETHODS_KEY, 0);
        this.threadCountClasses = JUnitCoreParameters.property(properties, THREADCOUNTCLASSES_KEY, 0);
        this.threadCountSuites = JUnitCoreParameters.property(properties, THREADCOUNTSUITES_KEY, 0);
        this.useUnlimitedThreads = JUnitCoreParameters.property(properties, USEUNLIMITEDTHREADS_KEY, false);
        this.parallelTestsTimeoutInSeconds = Math.max(JUnitCoreParameters.property(properties, PARALLEL_TIMEOUT_KEY, 0.0), 0.0);
        this.parallelTestsTimeoutForcedInSeconds = Math.max(JUnitCoreParameters.property(properties, PARALLEL_TIMEOUTFORCED_KEY, 0.0), 0.0);
        this.parallelOptimization = JUnitCoreParameters.property(properties, PARALLEL_OPTIMIZE_KEY, true);
    }

    private static Collection<String> lowerCase(String ... elements) {
        ArrayList<String> lowerCase = new ArrayList<String>();
        for (String element : elements) {
            lowerCase.add(element.toLowerCase());
        }
        return lowerCase;
    }

    private boolean isAllParallel() {
        return "all".equals(this.parallel);
    }

    public boolean isParallelMethods() {
        return this.isAllParallel() || JUnitCoreParameters.lowerCase("both", "methods", "suitesAndMethods", "classesAndMethods").contains(this.parallel);
    }

    public boolean isParallelClasses() {
        return this.isAllParallel() || JUnitCoreParameters.lowerCase("both", "classes", "suitesAndClasses", "classesAndMethods").contains(this.parallel);
    }

    public boolean isParallelSuites() {
        return this.isAllParallel() || JUnitCoreParameters.lowerCase("suites", "suitesAndClasses", "suitesAndMethods").contains(this.parallel);
    }

    @Deprecated
    public boolean isParallelBoth() {
        return this.isParallelMethods() && this.isParallelClasses();
    }

    public boolean isPerCoreThreadCount() {
        return this.perCoreThreadCount;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public int getThreadCountMethods() {
        return this.threadCountMethods;
    }

    public int getThreadCountClasses() {
        return this.threadCountClasses;
    }

    public int getThreadCountSuites() {
        return this.threadCountSuites;
    }

    public boolean isUseUnlimitedThreads() {
        return this.useUnlimitedThreads;
    }

    public double getParallelTestsTimeoutInSeconds() {
        return this.parallelTestsTimeoutInSeconds;
    }

    public double getParallelTestsTimeoutForcedInSeconds() {
        return this.parallelTestsTimeoutForcedInSeconds;
    }

    public boolean isNoThreading() {
        return !this.isParallelismSelected();
    }

    public boolean isParallelismSelected() {
        return this.isParallelSuites() || this.isParallelClasses() || this.isParallelMethods();
    }

    public boolean isParallelOptimization() {
        return this.parallelOptimization;
    }

    public String toString() {
        return "parallel='" + this.parallel + '\'' + ", perCoreThreadCount=" + this.perCoreThreadCount + ", threadCount=" + this.threadCount + ", useUnlimitedThreads=" + this.useUnlimitedThreads + ", threadCountSuites=" + this.threadCountSuites + ", threadCountClasses=" + this.threadCountClasses + ", threadCountMethods=" + this.threadCountMethods + ", parallelOptimization=" + this.parallelOptimization;
    }

    private static boolean property(Map<String, String> properties, String key, boolean fallback) {
        return properties.containsKey(key) ? Boolean.valueOf(properties.get(key)) : fallback;
    }

    private static String property(Map<String, String> properties, String key, String fallback) {
        return properties.containsKey(key) ? properties.get(key) : fallback;
    }

    private static int property(Map<String, String> properties, String key, int fallback) {
        return properties.containsKey(key) ? Integer.valueOf(properties.get(key)) : fallback;
    }

    private static double property(Map<String, String> properties, String key, double fallback) {
        return properties.containsKey(key) ? Double.valueOf(properties.get(key)) : fallback;
    }
}

