/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore.pc;

import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.surefire.junitcore.pc.Scheduler;
import org.apache.maven.surefire.junitcore.pc.SchedulingStrategy;

abstract class AbstractThreadPoolStrategy
extends SchedulingStrategy {
    private final ExecutorService threadPool;
    private final Collection<Future<?>> futureResults;
    private volatile boolean isDestroyed;

    AbstractThreadPoolStrategy(ConsoleLogger logger, ExecutorService threadPool) {
        this(logger, threadPool, null);
    }

    AbstractThreadPoolStrategy(ConsoleLogger logger, ExecutorService threadPool, Collection<Future<?>> futureResults) {
        super(logger);
        this.threadPool = threadPool;
        this.futureResults = futureResults;
    }

    protected final ExecutorService getThreadPool() {
        return this.threadPool;
    }

    protected final Collection<Future<?>> getFutureResults() {
        return this.futureResults;
    }

    @Override
    public void schedule(Runnable task) {
        if (this.canSchedule()) {
            Future<?> futureResult = this.threadPool.submit(task);
            if (this.futureResults != null) {
                this.futureResults.add(futureResult);
            }
        }
    }

    @Override
    protected boolean stop() {
        boolean wasRunning = this.disable();
        if (this.threadPool.isShutdown()) {
            wasRunning = false;
        } else {
            this.threadPool.shutdown();
        }
        return wasRunning;
    }

    @Override
    protected boolean stopNow() {
        boolean wasRunning = this.disable();
        if (this.threadPool.isShutdown()) {
            wasRunning = false;
        } else {
            this.threadPool.shutdownNow();
        }
        return wasRunning;
    }

    @Override
    protected void setDefaultShutdownHandler(Scheduler.ShutdownHandler handler) {
        if (this.threadPool instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor pool = (ThreadPoolExecutor)this.threadPool;
            handler.setRejectedExecutionHandler(pool.getRejectedExecutionHandler());
            pool.setRejectedExecutionHandler(handler);
        }
    }

    @Override
    public boolean destroy() {
        try {
            if (!this.isDestroyed) {
                this.disable();
                this.threadPool.shutdown();
                this.isDestroyed |= this.threadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            }
            return this.isDestroyed;
        }
        catch (InterruptedException e) {
            return false;
        }
    }
}

