/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.Map;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.api.report.ReporterFactory;
import org.apache.maven.surefire.api.report.StackTraceWriter;
import org.apache.maven.surefire.api.report.TestOutputReportEntry;
import org.apache.maven.surefire.api.report.TestReportListener;
import org.apache.maven.surefire.api.report.TestSetReportEntry;
import org.apache.maven.surefire.junitcore.ClassesParallelRunListener;
import org.apache.maven.surefire.junitcore.LogicalStream;
import org.apache.maven.surefire.junitcore.MethodsParallelRunListener;
import org.apache.maven.surefire.junitcore.TestMethod;
import org.apache.maven.surefire.junitcore.TestSet;

@Deprecated
abstract class ConcurrentRunListener
implements TestReportListener<TestOutputReportEntry> {
    private final Map<String, TestSet> classMethodCounts;
    private final ThreadLocal<TestReportListener<TestOutputReportEntry>> reporterManagerThreadLocal;
    private final boolean reportImmediately;
    private final ConsoleLogger logger;

    ConcurrentRunListener(ReporterFactory reporterFactory, boolean reportImmediately, Map<String, TestSet> classMethodCounts) {
        this.reportImmediately = reportImmediately;
        this.classMethodCounts = classMethodCounts;
        this.logger = reporterFactory.createTestReportListener();
        this.reporterManagerThreadLocal = ThreadLocal.withInitial(() -> ((ReporterFactory)reporterFactory).createTestReportListener());
    }

    public void testSetStarting(TestSetReportEntry description) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetCompleted(TestSetReportEntry result) {
        try {
            TestReportListener<TestOutputReportEntry> reporterManager = this.getRunListener();
            for (TestSet testSet : this.classMethodCounts.values()) {
                testSet.replay(reporterManager);
            }
        }
        finally {
            this.reporterManagerThreadLocal.remove();
        }
    }

    public void testFailed(ReportEntry failure) {
        TestMethod testMethod = this.getOrCreateThreadAttachedTestMethod(failure);
        if (testMethod != null) {
            testMethod.testFailure(failure);
            testMethod.detachFromCurrentThread();
        }
    }

    public void testError(ReportEntry failure) {
        TestMethod testMethod = this.getOrCreateThreadAttachedTestMethod(failure);
        if (testMethod != null) {
            testMethod.testError(failure);
            testMethod.detachFromCurrentThread();
        }
    }

    public void testSkipped(ReportEntry description) {
        TestSet testSet = this.getTestSet(description);
        TestMethod testMethod = testSet.createThreadAttachedTestMethod(description);
        testMethod.testIgnored(description);
        testSet.incrementFinishedTests(this.getRunListener(), this.reportImmediately);
        testMethod.detachFromCurrentThread();
    }

    public void testExecutionSkippedByUser() {
        this.getRunListener().testExecutionSkippedByUser();
    }

    public void testAssumptionFailure(ReportEntry failure) {
        TestMethod testMethod = this.getOrCreateThreadAttachedTestMethod(failure);
        if (testMethod != null) {
            testMethod.testAssumption(failure);
            testMethod.detachFromCurrentThread();
        }
    }

    public void testStarting(ReportEntry description) {
        TestSet testSet = this.getTestSet(description);
        testSet.createThreadAttachedTestMethod(description);
        this.checkIfTestSetCanBeReported(testSet);
        testSet.attachToThread();
    }

    public void testSucceeded(ReportEntry report) {
        TestMethod testMethod = TestMethod.getThreadTestMethod();
        if (testMethod != null) {
            testMethod.testFinished();
            testMethod.getTestSet().incrementFinishedTests(this.getRunListener(), this.reportImmediately);
            testMethod.detachFromCurrentThread();
        }
    }

    private TestMethod getOrCreateThreadAttachedTestMethod(ReportEntry description) {
        TestMethod threadTestMethod = TestMethod.getThreadTestMethod();
        if (threadTestMethod != null) {
            return threadTestMethod;
        }
        TestSet testSet = this.getTestSet(description);
        if (testSet == null) {
            this.logger.warning(description.getName());
            StackTraceWriter writer = description.getStackTraceWriter();
            if (writer != null) {
                this.logger.error(writer.writeTraceToString());
            }
            return null;
        }
        return testSet.createThreadAttachedTestMethod(description);
    }

    protected abstract void checkIfTestSetCanBeReported(TestSet var1);

    private TestSet getTestSet(ReportEntry description) {
        return this.classMethodCounts.get(description.getSourceName());
    }

    final TestReportListener<TestOutputReportEntry> getRunListener() {
        return this.reporterManagerThreadLocal.get();
    }

    public static ConcurrentRunListener createInstance(Map<String, TestSet> classMethodCounts, ReporterFactory reporterFactory, boolean parallelClasses, boolean parallelBoth) {
        return parallelClasses ? new ClassesParallelRunListener(classMethodCounts, reporterFactory) : new MethodsParallelRunListener(classMethodCounts, reporterFactory, !parallelBoth);
    }

    public void writeTestOutput(TestOutputReportEntry reportEntry) {
        TestMethod threadTestMethod = TestMethod.getThreadTestMethod();
        if (threadTestMethod != null) {
            LogicalStream logicalStream = threadTestMethod.getLogicalStream();
            logicalStream.write(reportEntry);
        } else {
            this.logger.info(reportEntry.getLog());
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String message) {
        this.logger.debug(message);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(String message) {
        this.logger.info(message);
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void warning(String message) {
        this.logger.warning(message);
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void error(String message) {
        this.logger.error(message);
    }

    public void error(String message, Throwable t) {
        this.logger.error(message, t);
    }

    public void error(Throwable t) {
        this.logger.error(t);
    }
}

