/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.LazyFileOutputStream;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.providers.ssh.SshCommandExecutor;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.apache.maven.wagon.resource.Resource;
import org.apache.maven.wagon.util.IoUtils;
import org.codehaus.plexus.util.StringUtils;

public class ScpWagon
extends AbstractWagon
implements SshCommandExecutor {
    public static String EXEC_CHANNEL = "exec";
    public static int DEFAULT_SSH_PORT = 22;
    public static int SOCKS5_PROXY_PORT = 1080;
    protected Session session = null;

    public void openConnection() throws AuthenticationException {
        try {
            if (this.authenticationInfo == null) {
                throw new IllegalArgumentException("Authentication Credentials cannot be null for SSH protocol");
            }
            JSch jsch = new JSch();
            int port = this.getRepository().getPort();
            if (port == -1) {
                port = DEFAULT_SSH_PORT;
            }
            String host = this.getRepository().getHost();
            this.session = jsch.getSession(this.authenticationInfo.getUserName(), host, port);
            if (this.authenticationInfo.getPassword() == null) {
                File privateKey = this.authenticationInfo.getPrivateKey() != null ? new File(this.authenticationInfo.getPrivateKey()) : this.findPrivateKey();
                if (privateKey.exists()) {
                    if (this.authenticationInfo.getPassphrase() == null) {
                        this.authenticationInfo.setPassphrase("");
                    }
                    this.fireSessionDebug("Using private key: " + privateKey);
                    jsch.addIdentity(privateKey.getAbsolutePath(), this.authenticationInfo.getPassphrase());
                } else {
                    String msg = "Private key was not found. You must define a private key or a password for repo: " + this.getRepository().getName();
                    throw new AuthenticationException(msg);
                }
            }
            if (this.proxyInfo != null && this.proxyInfo.getHost() != null) {
                ProxySOCKS5 proxy;
                int proxyPort = this.proxyInfo.getPort();
                if (proxyPort == SOCKS5_PROXY_PORT) {
                    proxy = new ProxySOCKS5(this.proxyInfo.getHost());
                    proxy.setUserPasswd(this.proxyInfo.getUserName(), this.proxyInfo.getPassword());
                } else {
                    proxy = new ProxyHTTP(this.proxyInfo.getHost(), proxyPort);
                    ((ProxyHTTP)proxy).setUserPasswd(this.proxyInfo.getUserName(), this.proxyInfo.getPassword());
                }
                proxy.connect(this.session, host, port);
            }
            WagonUserInfo ui = new WagonUserInfo(this.authenticationInfo);
            this.session.setUserInfo((UserInfo)ui);
            this.session.connect();
        }
        catch (Exception e) {
            this.fireSessionError(e);
            throw new AuthenticationException("Cannot connect. Reason: " + e.getMessage(), (Throwable)e);
        }
    }

    private File findPrivateKey() {
        File privateKey;
        String privateKeyDirectory = System.getProperty("wagon.privateKeyDirectory");
        if (privateKeyDirectory == null) {
            privateKeyDirectory = System.getProperty("user.home");
        }
        if (!(privateKey = new File(privateKeyDirectory, ".ssh/id_dsa")).exists()) {
            privateKey = new File(privateKeyDirectory, ".ssh/id_rsa");
        }
        return privateKey;
    }

    public void closeConnection() {
        if (this.session != null) {
            this.session.disconnect();
        }
    }

    public void executeCommand(String command) throws TransferFailedException {
        ChannelExec channel = null;
        try {
            this.fireTransferDebug("Executing command: " + command);
            channel = (ChannelExec)this.session.openChannel(EXEC_CHANNEL);
            channel.setCommand(command);
            channel.connect();
        }
        catch (JSchException e) {
            throw new TransferFailedException("Cannot execute remote command: " + command, (Throwable)e);
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void put(File source, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        RepositoryPermissions permissions;
        String basedir;
        block11: {
            basedir = this.getRepository().getBasedir();
            resourceName = StringUtils.replace((String)resourceName, (String)"\\", (String)"/");
            String dir = PathUtils.dirname((String)resourceName);
            dir = StringUtils.replace((String)dir, (String)"\\", (String)"/");
            Resource resource = new Resource(resourceName);
            this.firePutInitiated(resource, source);
            String mkdirCmd = "mkdir -p " + basedir + "/" + dir + "\n";
            this.executeCommand(mkdirCmd);
            ChannelExec channel = null;
            OutputStream out = null;
            try {
                String command = "scp -t " + basedir + "/" + resourceName;
                this.fireTransferDebug("Executing command: " + command);
                channel = (ChannelExec)this.session.openChannel(EXEC_CHANNEL);
                channel.setCommand(command);
                out = channel.getOutputStream();
                InputStream in = channel.getInputStream();
                channel.connect();
                if (ScpWagon.checkAck(in, false) != 0) {
                    throw new TransferFailedException("ACK check failed");
                }
                long filesize = source.length();
                command = "C0644 " + filesize + " ";
                command = resourceName.lastIndexOf(47) > 0 ? command + resourceName.substring(resourceName.lastIndexOf(47) + 1) : command + resourceName;
                command = command + "\n";
                out.write(command.getBytes());
                out.flush();
                if (ScpWagon.checkAck(in, false) != 0) {
                    throw new TransferFailedException("ACK check failed");
                }
                this.putTransfer(resource, source, out, false);
                byte[] buf = new byte[1024];
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
                if (ScpWagon.checkAck(in, false) != 0) {
                    throw new TransferFailedException("ACK check failed");
                }
                if (channel == null) break block11;
            }
            catch (IOException e) {
                try {
                    String msg = "Error occured while deploying '" + resourceName + "' to remote repository: " + this.getRepository().getUrl();
                    throw new TransferFailedException(msg, (Throwable)e);
                    catch (JSchException e2) {
                        msg = "Error occured while deploying '" + resourceName + "' to remote repository: " + this.getRepository().getUrl();
                        throw new TransferFailedException(msg, (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        IoUtils.close(out);
                        channel.disconnect();
                    }
                    throw throwable;
                }
            }
            IoUtils.close((OutputStream)out);
            channel.disconnect();
        }
        if ((permissions = this.getRepository().getPermissions()) != null && permissions.getGroup() != null) {
            this.executeCommand("chgrp -f " + permissions.getGroup() + " " + basedir + "/" + resourceName + "\n");
        }
        if (permissions != null && permissions.getFileMode() != null) {
            this.executeCommand("chmod -f " + permissions.getFileMode() + " " + basedir + "/" + resourceName + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        block19: {
            LazyFileOutputStream outputStream;
            ChannelExec channel;
            block18: {
                Resource resource = new Resource(resourceName);
                this.fireGetInitiated(resource, destination);
                channel = null;
                OutputStream out = null;
                InputStream in = null;
                this.createParentDirectories(destination);
                outputStream = new LazyFileOutputStream(destination);
                String basedir = this.getRepository().getBasedir();
                try {
                    int c;
                    String cmd = "scp -f " + basedir + "/" + resourceName;
                    this.fireTransferDebug("Executing command: " + cmd);
                    channel = (ChannelExec)this.session.openChannel(EXEC_CHANNEL);
                    channel.setCommand(cmd);
                    out = channel.getOutputStream();
                    in = channel.getInputStream();
                    channel.connect();
                    byte[] buf = new byte[1024];
                    buf[0] = 0;
                    out.write(buf, 0, 1);
                    out.flush();
                    while ((c = ScpWagon.checkAck(in, true)) == 67) {
                        in.read(buf, 0, 5);
                        int filesize = 0;
                        while (true) {
                            in.read(buf, 0, 1);
                            if (buf[0] == 32) break;
                            filesize = filesize * 10 + (buf[0] - 48);
                        }
                        resource.setContentLength((long)filesize);
                        int i = 0;
                        while (true) {
                            in.read(buf, i, 1);
                            if (buf[i] == 10) break;
                            ++i;
                        }
                        buf[0] = 0;
                        out.write(buf, 0, 1);
                        out.flush();
                        this.fireGetStarted(resource, destination);
                        TransferEvent transferEvent = new TransferEvent((Wagon)this, resource, 3, 5);
                        try {
                            int len;
                            do {
                                len = Math.min(buf.length, filesize);
                                in.read(buf, 0, len);
                                outputStream.write(buf, 0, len);
                                this.fireTransferProgress(transferEvent, buf, len);
                            } while ((filesize -= len) != 0);
                        }
                        catch (IOException e) {
                            boolean deleted;
                            this.fireTransferError(resource, e, 5);
                            IoUtils.close((OutputStream)outputStream);
                            if (destination.exists() && !(deleted = destination.delete())) {
                                destination.deleteOnExit();
                            }
                            String msg = "GET request of: " + resource + " from " + this.repository.getName() + "failed";
                            throw new TransferFailedException(msg, (Throwable)e);
                        }
                        this.fireGetCompleted(resource, destination);
                        if (ScpWagon.checkAck(in, true) != 0) {
                            throw new TransferFailedException("Wrong ACK");
                        }
                        this.fireTransferDebug("ACK check: OK");
                        buf[0] = 0;
                        out.write(buf, 0, 1);
                        out.flush();
                    }
                    if (out == null) break block18;
                }
                catch (JSchException e) {
                    this.handleGetException(resource, (Exception)((Object)e), destination);
                    break block19;
                }
                catch (IOException e) {
                    this.handleGetException(resource, e, destination);
                    break block19;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (out != null) {
                        IoUtils.close(out);
                    }
                    if (channel != null) {
                        channel.disconnect();
                    }
                    IoUtils.close((OutputStream)outputStream);
                }
                IoUtils.close((OutputStream)out);
            }
            if (channel != null) {
                channel.disconnect();
            }
            IoUtils.close((OutputStream)outputStream);
        }
    }

    protected void handleGetException(Resource resource, Exception e, File destination) throws TransferFailedException {
        boolean deleted;
        this.fireTransferError(resource, e, 5);
        if (destination.exists() && !(deleted = destination.delete())) {
            destination.deleteOnExit();
        }
        String msg = "Error occured while downloading from the remote repository:" + this.getRepository();
        throw new TransferFailedException(msg, (Throwable)e);
    }

    public boolean getIfNewer(String resourceName, File destination, long timestamp) {
        throw new UnsupportedOperationException("getIfNewer is scp wagon must be still implemented");
    }

    static int checkAck(InputStream in, boolean isGet) throws IOException, ResourceDoesNotExistException, TransferFailedException {
        int b = in.read();
        if (b == 0 || b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            String message = sb.toString();
            if (b == 1) {
                if (message.endsWith("No such file or directory\n") && isGet) {
                    throw new ResourceDoesNotExistException(message);
                }
                throw new TransferFailedException(message);
            }
            if (b == 2) {
                throw new TransferFailedException(message);
            }
        }
        return b;
    }

    public static class WagonUserInfo
    implements UserInfo {
        AuthenticationInfo authInfo;

        WagonUserInfo(AuthenticationInfo authInfo) {
            this.authInfo = authInfo;
        }

        public String getPassphrase() {
            return this.authInfo.getPassphrase();
        }

        public String getPassword() {
            return this.authInfo.getPassword();
        }

        public boolean promptPassphrase(String arg0) {
            return true;
        }

        public boolean promptPassword(String arg0) {
            return true;
        }

        public boolean promptYesNo(String arg0) {
            return true;
        }

        public void showMessage(String message) {
        }
    }
}

