/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.buildtools.maven2.plugin.javascript.jmt.compress;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.jmt.compress.CompressionException;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.jmt.compress.JSCompressor;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;

public class JSCompressorProxy
implements JSCompressor {
    private Object compressor;
    private Method compress;

    public JSCompressorProxy(Object compressor) throws InitializationException {
        this.compressor = compressor;
        try {
            this.compress = compressor.getClass().getMethod("compress", File.class, File.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Exception e) {
            throw new InitializationException("proxied object has no method compress(File,File,int,int)");
        }
    }

    public void compress(File input, File output, int level, int language) throws CompressionException {
        try {
            this.compress.invoke(this.compressor, input, output, level, language);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CompressionException) {
                throw (CompressionException)e.getTargetException();
            }
            throw new CompressionException("Failed to compress JS file", e, input);
        }
        catch (Exception e) {
            throw new CompressionException("Failed to compress JS file", e, input);
        }
    }
}

