/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.buildtools.maven2.plugin.javascript.obfuscator.filters.compression;

import java.util.Vector;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.obfuscator.filters.ObfuscatorFilter;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.obfuscator.filters.compression.CommentsHandler;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.obfuscator.filters.compression.CompressionHandler;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.obfuscator.filters.compression.NewlineHandler;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.obfuscator.filters.compression.WhitespaceHandler;
import org.apache.myfaces.buildtools.maven2.plugin.javascript.obfuscator.javascript15parser.AnnotatedToken;

public class CompressionFilter
implements ObfuscatorFilter {
    private boolean _stripComments;
    private boolean _stripWhitespaces;
    private boolean _stripNewlines;
    private Vector _handlers = new Vector();

    public CompressionFilter(boolean stripComments, boolean stripWhitespaces, boolean stripNewlines) {
        this._stripComments = stripComments;
        this._stripWhitespaces = stripWhitespaces;
        this._stripNewlines = stripNewlines;
        this.init();
    }

    public AnnotatedToken filter(AnnotatedToken startToken) {
        AnnotatedToken prevToken = null;
        for (AnnotatedToken token = startToken; token != null; token = token.getNext()) {
            for (CompressionHandler handler : this._handlers) {
                handler.handle(token, prevToken);
            }
            prevToken = token;
        }
        return startToken;
    }

    private void init() {
        if (this._stripComments) {
            this._handlers.add(new CommentsHandler());
        }
        if (this._stripWhitespaces) {
            this._handlers.add(new WhitespaceHandler());
        }
        if (this._stripNewlines) {
            this._handlers.add(new NewlineHandler());
        }
    }
}

