/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.mc.test.core.runner;

import java.lang.reflect.Field;
import java.util.List;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.apache.myfaces.mc.test.core.annotation.TestContainer;
import org.apache.myfaces.mc.test.core.runner.AbstractJsfTestContainer;
import org.apache.myfaces.mc.test.core.runner.MyFacesContainer;
import org.apache.myfaces.spi.InjectionProvider;
import org.apache.myfaces.spi.InjectionProviderFactory;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class MyFacesTestRunner
extends BlockJUnit4ClassRunner {
    public MyFacesTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected Statement withAfters(FrameworkMethod method, Object target, Statement statement) {
        return new ContainerAwareMethodInvoker(this.getTestClass(), method, super.withAfters(method, target, statement), target);
    }

    protected Statement withAfterClasses(Statement statement) {
        return new ClearSharedFacesConfiguration(statement, this.getTestClass());
    }

    private static class ClearSharedFacesConfiguration
    extends Statement {
        private final Statement defaultStatement;
        private final TestClass testClass;

        public ClearSharedFacesConfiguration(Statement defaultStatement, TestClass testClass) {
            this.defaultStatement = defaultStatement;
            this.testClass = testClass;
        }

        public void evaluate() throws Throwable {
            this.defaultStatement.evaluate();
            AbstractJsfTestContainer.tearDownClass(this.testClass.getJavaClass());
        }
    }

    private static class ContainerAwareMethodInvoker
    extends Statement {
        private final TestClass testClass;
        private final FrameworkMethod method;
        private final Object originalTarget;
        private final Statement defaultStatement;

        public ContainerAwareMethodInvoker(TestClass testClass, FrameworkMethod method, Statement defaultStatement, Object originalTarget) {
            this.testClass = testClass;
            this.method = method;
            this.defaultStatement = defaultStatement;
            this.originalTarget = originalTarget;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            MyFacesContainer currentTestContext = new MyFacesContainer(this.testClass);
            List fields = this.testClass.getAnnotatedFields(TestContainer.class);
            if (fields != null && !fields.isEmpty()) {
                for (FrameworkField field : fields) {
                    Field f = field.getField();
                    if (!f.getType().equals(MyFacesContainer.class)) continue;
                    f.setAccessible(true);
                    f.set(this.originalTarget, currentTestContext);
                }
            }
            currentTestContext.setUp(this.originalTarget);
            FacesContext facesContext = null;
            InjectionProvider injectionProvider = null;
            Object testCaseCreationMetadata = null;
            try {
                facesContext = currentTestContext.getFacesInitializer().initStartupFacesContext((ServletContext)currentTestContext.servletContext);
                InjectionProviderFactory ipf = InjectionProviderFactory.getInjectionProviderFactory((ExternalContext)facesContext.getExternalContext());
                injectionProvider = ipf.getInjectionProvider(facesContext.getExternalContext());
                if (injectionProvider != null) {
                    testCaseCreationMetadata = injectionProvider.inject(this.originalTarget);
                    injectionProvider.postConstruct(this.originalTarget, testCaseCreationMetadata);
                }
            }
            finally {
                currentTestContext.getFacesInitializer().destroyStartupFacesContext(facesContext);
            }
            try {
                this.defaultStatement.evaluate();
            }
            finally {
                facesContext = currentTestContext.getFacesInitializer().initShutdownFacesContext((ServletContext)currentTestContext.servletContext);
                if (injectionProvider != null) {
                    injectionProvider.preDestroy(this.originalTarget, testCaseCreationMetadata);
                }
                currentTestContext.getFacesInitializer().destroyShutdownFacesContext(facesContext);
                currentTestContext.tearDown();
            }
        }
    }
}

