/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import javax.faces.application.StateManager;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.renderkit.MyfacesResponseStateManager;
import org.apache.myfaces.shared_impl.util.StateUtils;

public class HtmlResponseStateManager
extends MyfacesResponseStateManager {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$renderkit$html$HtmlResponseStateManager == null ? (class$org$apache$myfaces$renderkit$html$HtmlResponseStateManager = HtmlResponseStateManager.class$("org.apache.myfaces.renderkit.html.HtmlResponseStateManager")) : class$org$apache$myfaces$renderkit$html$HtmlResponseStateManager));
    private static final String TREE_PARAM = "jsf_tree";
    private static final String STATE_PARAM = "jsf_state";
    private static final String VIEWID_PARAM = "jsf_viewid";
    private static final String BASE64_TREE_PARAM = "jsf_tree_64";
    private static final String BASE64_STATE_PARAM = "jsf_state_64";
    private static final String ZIP_CHARSET = "ISO-8859-1";
    static /* synthetic */ Class class$org$apache$myfaces$renderkit$html$HtmlResponseStateManager;

    public void writeState(FacesContext facescontext, StateManager.SerializedView serializedview) throws IOException {
        ResponseWriter responseWriter = facescontext.getResponseWriter();
        Object treeStruct = serializedview.getStructure();
        Object compStates = serializedview.getState();
        if (treeStruct != null) {
            if (treeStruct instanceof String) {
                responseWriter.startElement("input", null);
                responseWriter.writeAttribute("type", (Object)"hidden", null);
                responseWriter.writeAttribute("name", (Object)TREE_PARAM, null);
                responseWriter.writeAttribute("id", (Object)TREE_PARAM, null);
                if (StateUtils.isSecure(facescontext.getExternalContext())) {
                    treeStruct = StateUtils.construct(treeStruct, facescontext.getExternalContext());
                }
                responseWriter.writeAttribute("value", treeStruct, null);
                responseWriter.endElement("input");
            } else {
                responseWriter.startElement("input", null);
                responseWriter.writeAttribute("type", (Object)"hidden", null);
                responseWriter.writeAttribute("name", (Object)BASE64_TREE_PARAM, null);
                responseWriter.writeAttribute("id", (Object)BASE64_TREE_PARAM, null);
                responseWriter.writeAttribute("value", (Object)StateUtils.construct(treeStruct, facescontext.getExternalContext()), null);
                responseWriter.endElement("input");
            }
        } else {
            log.error((Object)"No tree structure to be saved in client response!");
        }
        if (compStates != null) {
            if (compStates instanceof String) {
                responseWriter.startElement("input", null);
                responseWriter.writeAttribute("type", (Object)"hidden", null);
                responseWriter.writeAttribute("name", (Object)STATE_PARAM, null);
                responseWriter.writeAttribute("id", (Object)STATE_PARAM, null);
                if (StateUtils.isSecure(facescontext.getExternalContext())) {
                    compStates = StateUtils.construct(compStates, facescontext.getExternalContext());
                }
                responseWriter.writeAttribute("value", compStates, null);
                responseWriter.endElement("input");
            } else {
                responseWriter.startElement("input", null);
                responseWriter.writeAttribute("type", (Object)"hidden", null);
                responseWriter.writeAttribute("name", (Object)BASE64_STATE_PARAM, null);
                responseWriter.writeAttribute("id", (Object)BASE64_STATE_PARAM, null);
                responseWriter.writeAttribute("value", (Object)StateUtils.construct(compStates, facescontext.getExternalContext()), null);
                responseWriter.endElement("input");
            }
        } else {
            log.error((Object)"No component states to be saved in client response!");
        }
        responseWriter.startElement("input", null);
        responseWriter.writeAttribute("type", (Object)"hidden", null);
        responseWriter.writeAttribute("name", (Object)VIEWID_PARAM, null);
        responseWriter.writeAttribute("id", (Object)VIEWID_PARAM, null);
        responseWriter.writeAttribute("value", (Object)facescontext.getViewRoot().getViewId(), null);
        responseWriter.endElement("input");
    }

    public void writeStateAsUrlParams(FacesContext facescontext, StateManager.SerializedView serializedview) throws IOException {
        ResponseWriter responseWriter = facescontext.getResponseWriter();
        Object treeStruct = serializedview.getStructure();
        Object compStates = serializedview.getState();
        if (treeStruct != null) {
            if (treeStruct instanceof String) {
                if (StateUtils.isSecure(facescontext.getExternalContext())) {
                    treeStruct = StateUtils.construct(treeStruct, facescontext.getExternalContext());
                }
                this.writeStateParam(responseWriter, TREE_PARAM, (String)treeStruct);
            } else {
                this.writeStateParam(responseWriter, BASE64_TREE_PARAM, StateUtils.construct(treeStruct, facescontext.getExternalContext()));
            }
        } else {
            log.error((Object)"No tree structure to be saved in client response!");
        }
        if (compStates != null) {
            if (treeStruct != null) {
                responseWriter.write(38);
            }
            if (compStates instanceof String) {
                if (StateUtils.isSecure(facescontext.getExternalContext())) {
                    compStates = StateUtils.construct(compStates, facescontext.getExternalContext());
                }
                this.writeStateParam(responseWriter, STATE_PARAM, (String)compStates);
            } else {
                this.writeStateParam(responseWriter, BASE64_STATE_PARAM, StateUtils.construct(compStates, facescontext.getExternalContext()));
            }
        } else {
            log.error((Object)"No component states to be saved in client response!");
        }
        if (treeStruct != null || compStates != null) {
            responseWriter.write(38);
        }
        this.writeStateParam(responseWriter, VIEWID_PARAM, facescontext.getViewRoot().getViewId());
    }

    public Object getTreeStructureToRestore(FacesContext facescontext, String viewId) {
        Map reqParamMap = facescontext.getExternalContext().getRequestParameterMap();
        Object param = reqParamMap.get(VIEWID_PARAM);
        if (param == null || !param.equals(viewId)) {
            return null;
        }
        param = reqParamMap.get(TREE_PARAM);
        if (param != null) {
            if (StateUtils.isSecure(facescontext.getExternalContext())) {
                param = StateUtils.construct(param, facescontext.getExternalContext());
            }
            return param;
        }
        param = reqParamMap.get(BASE64_TREE_PARAM);
        if (param != null) {
            return StateUtils.reconstruct((String)param, facescontext.getExternalContext());
        }
        return null;
    }

    public Object getComponentStateToRestore(FacesContext facescontext) {
        Map reqParamMap = facescontext.getExternalContext().getRequestParameterMap();
        Object param = reqParamMap.get(STATE_PARAM);
        if (param != null) {
            if (StateUtils.isSecure(facescontext.getExternalContext())) {
                param = StateUtils.construct(param, facescontext.getExternalContext());
            }
            return param;
        }
        param = reqParamMap.get(BASE64_STATE_PARAM);
        if (param != null) {
            return StateUtils.reconstruct((String)param, facescontext.getExternalContext());
        }
        return null;
    }

    private void writeStateParam(ResponseWriter writer, String name, String value) throws IOException {
        writer.write(name);
        writer.write(61);
        writer.write(URLEncoder.encode(value, writer.getCharacterEncoding()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

