/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.renderkit.html.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_impl.config.MyfacesConfig;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRendererUtils;

public final class JavascriptUtils {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$shared_impl$renderkit$html$util$JavascriptUtils == null ? (class$org$apache$myfaces$shared_impl$renderkit$html$util$JavascriptUtils = JavascriptUtils.class$("org.apache.myfaces.shared_impl.renderkit.html.util.JavascriptUtils")) : class$org$apache$myfaces$shared_impl$renderkit$html$util$JavascriptUtils));
    public static final String JAVASCRIPT_DETECTED = (class$org$apache$myfaces$shared_impl$renderkit$html$util$JavascriptUtils == null ? (class$org$apache$myfaces$shared_impl$renderkit$html$util$JavascriptUtils = JavascriptUtils.class$("org.apache.myfaces.shared_impl.renderkit.html.util.JavascriptUtils")) : class$org$apache$myfaces$shared_impl$renderkit$html$util$JavascriptUtils).getName() + ".JAVASCRIPT_DETECTED";
    private static final String AUTO_SCROLL_PARAM = "autoScroll";
    private static final String AUTO_SCROLL_FUNCTION = "getScrolling";
    private static final String OLD_VIEW_ID = (class$org$apache$myfaces$shared_impl$renderkit$html$util$JavascriptUtils == null ? (class$org$apache$myfaces$shared_impl$renderkit$html$util$JavascriptUtils = JavascriptUtils.class$("org.apache.myfaces.shared_impl.renderkit.html.util.JavascriptUtils")) : class$org$apache$myfaces$shared_impl$renderkit$html$util$JavascriptUtils) + ".OLD_VIEW_ID";
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "delete", "do", "double", "else", "export", "extends", "false", "final", "finally", "float", "for", "function", "goto", "if", "implements", "in", "instanceof", "int", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "typeof", "var", "void", "while", "with"));
    static /* synthetic */ Class class$org$apache$myfaces$shared_impl$renderkit$html$util$JavascriptUtils;

    private JavascriptUtils() {
    }

    public static String getValidJavascriptName(String s, boolean checkForReservedWord) {
        if (checkForReservedWord && RESERVED_WORDS.contains(s)) {
            return s + "_";
        }
        StringBuffer buf = null;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            byte[] bytes;
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                if (buf == null) continue;
                buf.append(c);
                continue;
            }
            if (buf == null) {
                buf = new StringBuffer(s.length() + 10);
                buf.append(s.substring(0, i));
            }
            buf.append('_');
            if (c < '\u0010') {
                buf.append('0');
            }
            if (c < '\u0080') {
                buf.append(Integer.toHexString(c).toUpperCase());
                continue;
            }
            try {
                bytes = Character.toString(c).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            for (int j = 0; j < bytes.length; ++j) {
                int intVal = bytes[j];
                if (intVal < 0) {
                    intVal = 256 + intVal;
                } else if (intVal < 16) {
                    buf.append('0');
                }
                buf.append(Integer.toHexString(intVal).toUpperCase());
            }
        }
        return buf == null ? s : buf.toString();
    }

    public static String encodeString(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer sb = null;
        for (int i = 0; i < string.length(); ++i) {
            String app = null;
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    app = "\\";
                    break;
                }
                case '\"': {
                    app = "\\\"";
                    break;
                }
                case '\'': {
                    app = "\\'";
                    break;
                }
                case '\n': {
                    app = "\\n";
                    break;
                }
                case '\r': {
                    app = "\\r";
                }
            }
            if (app != null) {
                if (sb == null) {
                    sb = new StringBuffer(string.substring(0, i));
                }
                sb.append(app);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return string;
        }
        return sb.toString();
    }

    public static boolean isJavascriptAllowed(ExternalContext externalContext) {
        MyfacesConfig myfacesConfig = MyfacesConfig.getCurrentInstance(externalContext);
        if (myfacesConfig.isAllowJavascript()) {
            if (myfacesConfig.isDetectJavascript()) {
                return JavascriptUtils.isJavascriptDetected(externalContext);
            }
            return true;
        }
        return false;
    }

    public static void setJavascriptDetected(HttpSession session, boolean value) {
        session.setAttribute(JAVASCRIPT_DETECTED, (Object)value);
    }

    public static boolean isJavascriptDetected(ExternalContext externalContext) {
        Boolean sessionValue = (Boolean)externalContext.getSessionMap().get(JAVASCRIPT_DETECTED);
        return sessionValue != null && sessionValue != false;
    }

    public static void appendAutoScrollAssignment(StringBuffer onClickValue, String formName) {
        onClickValue.append("if(window.getScrolling!=undefined)");
        onClickValue.append("{");
        onClickValue.append("document.forms['").append(formName).append("']");
        onClickValue.append(".elements['").append(AUTO_SCROLL_PARAM).append("']");
        onClickValue.append(".value=").append(AUTO_SCROLL_FUNCTION).append("();");
        onClickValue.append("}");
    }

    public static void renderAutoScrollHiddenInput(FacesContext facesContext, ResponseWriter writer) throws IOException {
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)AUTO_SCROLL_PARAM, null);
        writer.endElement("input");
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
    }

    public static void renderAutoScrollFunction(FacesContext facesContext, ResponseWriter writer) throws IOException {
        String scrolling;
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        StringBuffer script = new StringBuffer();
        script.append("function ");
        script.append(AUTO_SCROLL_FUNCTION);
        script.append("() {\n");
        script.append("    var x = 0; var y = 0;\n");
        script.append("    if (self.pageXOffset || self.pageYOffset) {\n        x = self.pageXOffset;\n        y = self.pageYOffset;\n    } else if ((document.documentElement && document.documentElement.scrollLeft)||(document.documentElement && document.documentElement.scrollTop)) {\n        x = document.documentElement.scrollLeft;\n        y = document.documentElement.scrollTop;\n    } else if (document.body) {\n        x = document.body.scrollLeft;\n        y = document.body.scrollTop;\n    }\n    return x + \",\" + y;\n}\n");
        ExternalContext externalContext = facesContext.getExternalContext();
        String oldViewId = JavascriptUtils.getOldViewId(externalContext);
        if (oldViewId != null && oldViewId.equals(facesContext.getViewRoot().getViewId()) && (scrolling = (String)externalContext.getRequestParameterMap().get(AUTO_SCROLL_PARAM)) != null && scrolling.length() > 0) {
            String x = "0";
            String y = "0";
            int comma = scrolling.indexOf(44);
            if (comma == -1) {
                log.warn((Object)("Illegal autoscroll request parameter: " + scrolling));
            } else {
                x = scrolling.substring(0, comma);
                if (x.equals("undefined")) {
                    x = "0";
                }
                if ((y = scrolling.substring(comma + 1)).equals("undefined")) {
                    y = "0";
                }
            }
            script.append("window.scrollTo(").append(x).append(",").append(y).append(");\n");
        }
        writer.writeText((Object)script.toString(), null);
        writer.endElement("script");
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
    }

    public static void setOldViewId(ExternalContext externalContext, String viewId) {
        externalContext.getRequestMap().put(OLD_VIEW_ID, viewId);
    }

    public static String getOldViewId(ExternalContext externalContext) {
        return (String)externalContext.getRequestMap().get(OLD_VIEW_ID);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

