/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.convert.Converter;
import javax.faces.event.ActionListener;
import javax.faces.validator.Validator;
import org.apache.myfaces.test.mock.MockActionListener;
import org.apache.myfaces.test.mock.MockNavigationHandler;
import org.apache.myfaces.test.mock.MockStateManager;
import org.apache.myfaces.test.mock.MockViewHandler;

public abstract class MockApplication10
extends Application {
    private ActionListener actionListener = null;
    private Map components = null;
    private Map converters = null;
    private Map converters1 = null;
    private Locale defaultLocale = null;
    private String defaultRenderKitId = null;
    private String messageBundle = null;
    private NavigationHandler navigationHandler = null;
    private StateManager stateManager = null;
    private Collection supportedLocales = null;
    private Map validators = null;
    private ViewHandler viewHandler = null;

    public MockApplication10() {
        this.setActionListener(new MockActionListener());
        this.components = new HashMap();
        this.converters = new HashMap();
        this.converters1 = new HashMap();
        this.setDefaultLocale(Locale.getDefault());
        this.setDefaultRenderKitId("HTML_BASIC");
        this.setNavigationHandler(new MockNavigationHandler());
        this.setStateManager(new MockStateManager());
        this.setSupportedLocales(new ArrayList());
        this.validators = new HashMap();
        this.setViewHandler(new MockViewHandler());
        this.addConverter("javax.faces.BigDecimal", "javax.faces.convert.BigDecimalConverter");
        this.addConverter("javax.faces.BigInteger", "javax.faces.convert.BigIntegerConverter");
        this.addConverter("javax.faces.Boolean", "javax.faces.convert.BooleanConverter");
        this.addConverter("javax.faces.Byte", "javax.faces.convert.ByteConverter");
        this.addConverter("javax.faces.Character", "javax.faces.convert.CharacterConverter");
        this.addConverter("javax.faces.DateTime", "javax.faces.convert.DateTimeConverter");
        this.addConverter("javax.faces.Double", "javax.faces.convert.DoubleConverter");
        this.addConverter("javax.faces.Float", "javax.faces.convert.FloatConverter");
        this.addConverter("javax.faces.Integer", "javax.faces.Convert.IntegerConverter");
        this.addConverter("javax.faces.Long", "javax.faces.convert.LongConverter");
        this.addConverter("javax.faces.Number", "javax.faces.convert.NumberConverter");
        this.addConverter("javax.faces.Short", "javax.faces.convert.ShortConverter");
        this.addConverter(Boolean.class, "javax.faces.convert.BooleanConverter");
        this.addConverter(Boolean.TYPE, "javax.faces.convert.BooleanConverter");
        this.addConverter(Byte.class, "javax.faces.convert.ByteConverter");
        this.addConverter(Byte.TYPE, "javax.faces.convert.ByteConverter");
        this.addConverter(Character.class, "javax.faces.convert.CharacterConverter");
        this.addConverter(Character.TYPE, "javax.faces.convert.CharacterConverter");
        this.addConverter(Double.class, "javax.faces.convert.DoubleConverter");
        this.addConverter(Double.TYPE, "javax.faces.convert.DoubleConverter");
        this.addConverter(Float.class, "javax.faces.convert.FloatConverter");
        this.addConverter(Float.TYPE, "javax.faces.convert.FloatConverter");
        this.addConverter(Integer.class, "javax.faces.convert.IntegerConverter");
        this.addConverter(Integer.TYPE, "javax.faces.convert.IntegerConverter");
        this.addConverter(Long.class, "javax.faces.convert.LongConverter");
        this.addConverter(Long.TYPE, "javax.faces.convert.LongConverter");
        this.addConverter(Short.class, "javax.faces.convert.ShortConverter");
        this.addConverter(Short.TYPE, "javax.faces.convert.ShortConverter");
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public String getDefaultRenderKitId() {
        return this.defaultRenderKitId;
    }

    public void setDefaultRenderKitId(String defaultRenderKitId) {
        this.defaultRenderKitId = defaultRenderKitId;
    }

    public String getMessageBundle() {
        return this.messageBundle;
    }

    public void setMessageBundle(String messageBundle) {
        this.messageBundle = messageBundle;
    }

    public NavigationHandler getNavigationHandler() {
        return this.navigationHandler;
    }

    public void setNavigationHandler(NavigationHandler navigationHandler) {
        this.navigationHandler = navigationHandler;
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public void setStateManager(StateManager stateManager) {
        this.stateManager = stateManager;
    }

    public Iterator getSupportedLocales() {
        return this.supportedLocales.iterator();
    }

    public void setSupportedLocales(Collection supportedLocales) {
        this.supportedLocales = supportedLocales;
    }

    public ViewHandler getViewHandler() {
        return this.viewHandler;
    }

    public void setViewHandler(ViewHandler viewHandler) {
        this.viewHandler = viewHandler;
    }

    public void addComponent(String componentType, String componentClass) {
        this.components.put(componentType, componentClass);
    }

    public UIComponent createComponent(String componentType) {
        if (componentType == null) {
            throw new NullPointerException("Requested component type is null");
        }
        String componentClass = (String)this.components.get(componentType);
        if (componentClass == null) {
            throw new FacesException("No component class registered for component type '" + componentType + '\'');
        }
        try {
            Class<?> clazz = Class.forName(componentClass);
            return (UIComponent)clazz.newInstance();
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    public Iterator getComponentTypes() {
        return this.components.keySet().iterator();
    }

    public void addConverter(String converterId, String converterClass) {
        this.converters.put(converterId, converterClass);
    }

    public void addConverter(Class targetClass, String converterClass) {
        this.converters1.put(targetClass, converterClass);
    }

    public Converter createConverter(String converterId) {
        String converterClass = (String)this.converters.get(converterId);
        if (converterClass == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(converterClass);
            return (Converter)clazz.newInstance();
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    public Converter createConverter(Class targetClass) {
        String converterClass = (String)this.converters1.get(targetClass);
        if (converterClass == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(converterClass);
            return (Converter)clazz.newInstance();
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    public Iterator getConverterIds() {
        return this.converters.keySet().iterator();
    }

    public Iterator getConverterTypes() {
        return this.converters1.keySet().iterator();
    }

    public void addValidator(String validatorId, String validatorClass) {
        this.validators.put(validatorId, validatorClass);
    }

    public Validator createValidator(String validatorId) {
        String validatorClass = (String)this.validators.get(validatorId);
        try {
            Class<?> clazz = Class.forName(validatorClass);
            return (Validator)clazz.newInstance();
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    public Iterator getValidatorIds() {
        return this.validators.keySet().iterator();
    }
}

