/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.test.mock.MockHttpServletRequest;
import org.apache.myfaces.test.mock._ApplicationMap;
import org.apache.myfaces.test.mock._CookieMap;
import org.apache.myfaces.test.mock._InitParameterMap;
import org.apache.myfaces.test.mock._RequestHeaderMap;
import org.apache.myfaces.test.mock._RequestHeaderValuesMap;
import org.apache.myfaces.test.mock._RequestMap;
import org.apache.myfaces.test.mock._RequestParameterMap;
import org.apache.myfaces.test.mock._RequestParameterValuesMap;
import org.apache.myfaces.test.mock._SessionMap;

public abstract class MockExternalContext10
extends ExternalContext {
    protected ServletContext context;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    private Map applicationMap;
    private Map initParameterMap;
    private Map requestMap;
    private Map requestCookieMap;
    private Map requestHeaderMap;
    private Map requestParameterMap;
    private Map requestParameterValuesMap;
    private Map requestHeaderValuesMap;
    private Map sessionMap;

    public MockExternalContext10(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        this.context = context;
        this.request = request;
        this.response = response;
        this.applicationMap = null;
        this.initParameterMap = null;
        this.requestMap = null;
        this.requestCookieMap = null;
        this.requestHeaderMap = null;
        this.requestParameterMap = null;
        this.requestParameterValuesMap = null;
        this.requestHeaderValuesMap = null;
        this.sessionMap = null;
    }

    public void addRequestCookieMap(Cookie cookie) {
        Map map = this.getRequestCookieMap();
        if (this.request instanceof MockHttpServletRequest && map instanceof _CookieMap) {
            ((MockHttpServletRequest)this.request).addCookie(cookie);
        } else {
            map.put(cookie.getName(), cookie);
        }
    }

    public void setRequestCookieMap(Map map) {
        this.requestCookieMap = map;
    }

    public void addRequestParameterMap(String key, String value) {
        Map map = this.getRequestParameterMap();
        if (this.request instanceof MockHttpServletRequest && map instanceof _RequestParameterMap) {
            ((MockHttpServletRequest)this.request).addParameter(key, value);
        } else {
            map.put(key, value);
        }
    }

    public void setRequestParameterMap(Map map) {
        this.requestParameterMap = map;
    }

    public void addRequestHeader(String key, String value) {
        Map map = this.getRequestHeaderMap();
        if (this.request instanceof MockHttpServletRequest && map instanceof _RequestHeaderMap) {
            ((MockHttpServletRequest)this.request).addHeader(key, value);
        } else {
            map.put(key, value);
        }
    }

    public void setRequestHeaderMap(Map map) {
        this.requestHeaderMap = map;
    }

    public void dispatch(String requestURI) throws IOException, FacesException {
        RequestDispatcher requestDispatcher = this.request.getRequestDispatcher(requestURI);
        if (requestDispatcher == null) {
            this.response.sendError(404);
            return;
        }
        try {
            requestDispatcher.forward((ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (ServletException e) {
            if (e.getMessage() != null) {
                throw new FacesException(e.getMessage(), (Throwable)e);
            }
            throw new FacesException((Throwable)e);
        }
    }

    public String encodeActionURL(String sb) {
        return sb;
    }

    public String encodeNamespace(String aValue) {
        return aValue;
    }

    public String encodeResourceURL(String sb) {
        return sb;
    }

    public Map getApplicationMap() {
        if (this.applicationMap == null) {
            this.applicationMap = new _ApplicationMap(this.context);
        }
        return this.applicationMap;
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public Object getContext() {
        return this.context;
    }

    public String getInitParameter(String name) {
        return this.context.getInitParameter(name);
    }

    public Map getInitParameterMap() {
        if (this.initParameterMap == null) {
            this.initParameterMap = new _InitParameterMap(this.context);
        }
        return this.initParameterMap;
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public Object getRequest() {
        return this.request;
    }

    public String getRequestContextPath() {
        return this.request.getContextPath();
    }

    public Map getRequestCookieMap() {
        if (this.requestCookieMap == null) {
            this.requestCookieMap = new _CookieMap(this.request);
        }
        return this.requestCookieMap;
    }

    public Map getRequestHeaderMap() {
        if (this.requestHeaderMap == null) {
            this.requestHeaderMap = new _RequestHeaderMap(this.request);
        }
        return this.requestHeaderMap;
    }

    public Map getRequestHeaderValuesMap() {
        if (this.requestHeaderValuesMap == null) {
            this.requestHeaderValuesMap = new _RequestHeaderValuesMap(this.request);
        }
        return this.requestHeaderValuesMap;
    }

    public Locale getRequestLocale() {
        return this.request.getLocale();
    }

    public Iterator getRequestLocales() {
        return new LocalesIterator(this.request.getLocales());
    }

    public Map getRequestMap() {
        if (this.requestMap == null) {
            this.requestMap = new _RequestMap((ServletRequest)this.request);
        }
        return this.requestMap;
    }

    public Map getRequestParameterMap() {
        if (this.requestParameterMap == null) {
            this.requestParameterMap = new _RequestParameterMap((ServletRequest)this.request);
        }
        return this.requestParameterMap;
    }

    public Iterator getRequestParameterNames() {
        final Enumeration enumer = this.request.getParameterNames();
        Iterator it = new Iterator(){

            @Override
            public boolean hasNext() {
                return enumer.hasMoreElements();
            }

            public Object next() {
                return enumer.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
            }
        };
        return it;
    }

    public Map getRequestParameterValuesMap() {
        if (this.requestParameterValuesMap == null) {
            this.requestParameterValuesMap = new _RequestParameterValuesMap((ServletRequest)this.request);
        }
        return this.requestParameterValuesMap;
    }

    public String getRequestPathInfo() {
        return this.request.getPathInfo();
    }

    public String getRequestServletPath() {
        return this.request.getServletPath();
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.context.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.context.getResourceAsStream(path);
    }

    public Set getResourcePaths(String path) {
        return this.context.getResourcePaths(path);
    }

    public Object getResponse() {
        return this.response;
    }

    public Object getSession(boolean create) {
        return this.request.getSession(create);
    }

    public Map getSessionMap() {
        if (this.sessionMap == null) {
            this.sessionMap = new _SessionMap(this.request);
        }
        return this.sessionMap;
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    public void log(String message) {
        this.context.log(message);
    }

    public void log(String message, Throwable throwable) {
        this.context.log(message, throwable);
    }

    public void redirect(String requestURI) throws IOException {
        this.response.sendRedirect(requestURI);
        FacesContext.getCurrentInstance().responseComplete();
    }

    public String encodeWebsocketURL(String baseUrl) {
        Integer port = 8080;
        Integer n = port = port == 0 ? null : port;
        if (port != null && !port.equals(this.request.getServerPort())) {
            String scheme = "http";
            String serverName = this.request.getServerName();
            try {
                String url = new URL(scheme, serverName, port, baseUrl).toExternalForm();
                url = url.replaceFirst("http", "ws");
                return url;
            }
            catch (MalformedURLException ex) {
                return baseUrl;
            }
        }
        return baseUrl;
    }

    private class LocalesIterator
    implements Iterator {
        private Enumeration locales;

        public LocalesIterator(Enumeration locales) {
            this.locales = locales;
        }

        @Override
        public boolean hasNext() {
            return this.locales.hasMoreElements();
        }

        public Object next() {
            return this.locales.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

