/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.test.mock.MockPrintWriter;
import org.apache.myfaces.test.mock.MockServletOutputStream;

public class MockHttpServletResponse
implements HttpServletResponse {
    private String encoding = "ISO-8859-1";
    private String contentType = "text/html";
    private List headers = new ArrayList();
    private String message = null;
    private int status = 200;
    private ServletOutputStream stream = null;
    private PrintWriter writer = null;
    private boolean committed = false;
    private long contentLength = 0L;
    private int bufferSize = 0;
    private Locale locale = Locale.getDefault();
    private Map<String, Cookie> cookies = new HashMap<String, Cookie>(4);
    private static SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");

    public String getHeader(String name) {
        String match = name + ':';
        for (String header : this.headers) {
            if (!header.startsWith(match)) continue;
            return header.substring(match.length() + 1).trim();
        }
        return null;
    }

    public Cookie getCookie(String name) {
        return this.cookies.get(name);
    }

    public Map<String, Cookie> getCookies() {
        return this.cookies;
    }

    public String getMessage() {
        return this.message;
    }

    public int getStatus() {
        return this.status;
    }

    public void setOutputStream(ServletOutputStream stream) {
        this.stream = stream;
    }

    public void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.put(cookie.getName(), cookie);
    }

    public void addDateHeader(String name, long value) {
        this.headers.add(name + ": " + this.formatDate(value));
    }

    public void addHeader(String name, String value) {
        this.headers.add(name + ": " + value);
    }

    public void addIntHeader(String name, int value) {
        this.headers.add(name + ": " + value);
    }

    public boolean containsHeader(String name) {
        return this.getHeader(name) != null;
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeURL(String url) {
        return url;
    }

    public void sendError(int status) {
        if (this.committed) {
            throw new IllegalStateException("Response is already committed");
        }
        this.status = status;
        this.committed = true;
    }

    public void sendError(int status, String message) {
        if (this.committed) {
            throw new IllegalStateException("Response is already committed");
        }
        this.status = status;
        this.message = message;
        this.committed = true;
    }

    public void sendRedirect(String location) {
        if (this.committed) {
            throw new IllegalStateException("Response is already committed");
        }
        this.setStatus(302);
        this.setHeader("Location", location);
        this.message = location;
        this.committed = true;
    }

    public void setDateHeader(String name, long value) {
        this.removeHeader(name);
        this.addDateHeader(name, value);
    }

    public void setHeader(String name, String value) {
        this.removeHeader(name);
        this.addHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.removeHeader(name);
        this.addIntHeader(name, value);
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setStatus(int status, String message) {
        this.status = status;
        this.message = message;
    }

    public void flushBuffer() {
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.stream == null) {
            if (this.writer != null) {
                throw new IllegalStateException("Cannot call getOutputStream() after getWriter() has been called");
            }
            this.stream = new MockServletOutputStream(new ByteArrayOutputStream());
        }
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            if (this.stream != null) {
                throw new IllegalStateException("Cannot call getWriter() after getOutputStream() was called");
            }
            this.writer = new MockPrintWriter(new CharArrayWriter());
        }
        return this.writer;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void reset() {
    }

    public void resetBuffer() {
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public void setCharacterEncoding(String charset) {
        this.encoding = charset;
    }

    public void setContentLength(int length) {
        this.contentLength = length;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    private String formatDate(long date) {
        return format.format(new Date(date));
    }

    private void removeHeader(String name) {
        String match = name + ':';
        Iterator headers = this.headers.iterator();
        while (headers.hasNext()) {
            String header = (String)headers.next();
            if (!header.startsWith(match)) continue;
            headers.remove();
            return;
        }
    }

    public Collection<String> getHeaderNames() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<String> getHeaders(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setContentLengthLong(long l) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

