/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock.lifecycle;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.ViewExpiredException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.apache.myfaces.test.mock.lifecycle.DefaultRestoreViewSupport;
import org.apache.myfaces.test.mock.lifecycle.PhaseExecutor;
import org.apache.myfaces.test.mock.lifecycle.RestoreViewSupport;
import org.apache.myfaces.test.util.JsfVersion;

class RestoreViewExecutor
implements PhaseExecutor {
    private static final Logger log = Logger.getLogger(RestoreViewExecutor.class.getName());
    private RestoreViewSupport _restoreViewSupport;

    RestoreViewExecutor() {
    }

    @Override
    public boolean execute(FacesContext facesContext) {
        if (facesContext == null) {
            throw new FacesException("FacesContext is null");
        }
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        if (JsfVersion.supports12()) {
            viewHandler.initView(facesContext);
        }
        UIViewRoot viewRoot = facesContext.getViewRoot();
        RestoreViewSupport restoreViewSupport = this.getRestoreViewSupport();
        if (viewRoot != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "View already exists in the FacesContext");
            }
            viewRoot.setLocale(facesContext.getExternalContext().getRequestLocale());
            restoreViewSupport.processComponentBinding(facesContext, (UIComponent)viewRoot);
            return false;
        }
        String viewId = restoreViewSupport.calculateViewId(facesContext);
        if (restoreViewSupport.isPostback(facesContext)) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Request is a postback");
            }
            if ((viewRoot = viewHandler.restoreView(facesContext, viewId)) == null) {
                if (JsfVersion.supports12()) {
                    throw new ViewExpiredException("The expected view was not returned for the view identifier: " + viewId, viewId);
                }
                throw new RuntimeException("The expected view was not returned for the view identifier: " + viewId);
            }
            restoreViewSupport.processComponentBinding(facesContext, (UIComponent)viewRoot);
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Request is not a postback. New UIViewRoot will be created");
            }
            viewRoot = viewHandler.createView(facesContext, viewId);
            facesContext.renderResponse();
        }
        facesContext.setViewRoot(viewRoot);
        return false;
    }

    protected RestoreViewSupport getRestoreViewSupport() {
        if (this._restoreViewSupport == null) {
            this._restoreViewSupport = new DefaultRestoreViewSupport();
        }
        return this._restoreViewSupport;
    }

    public void setRestoreViewSupport(RestoreViewSupport restoreViewSupport) {
        this._restoreViewSupport = restoreViewSupport;
    }

    @Override
    public PhaseId getPhase() {
        return PhaseId.RESTORE_VIEW;
    }
}

