/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.base.junit4;

import jakarta.faces.FactoryFinder;
import jakarta.faces.application.Application;
import jakarta.faces.application.ApplicationFactory;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.FacesContextFactory;
import jakarta.faces.lifecycle.Lifecycle;
import jakarta.faces.lifecycle.LifecycleFactory;
import jakarta.faces.render.RenderKit;
import jakarta.faces.render.RenderKitFactory;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.myfaces.test.config.ResourceBundleVarNames;
import org.apache.myfaces.test.mock.MockExternalContext;
import org.apache.myfaces.test.mock.MockFacesContext;
import org.apache.myfaces.test.mock.MockHttpServletRequest;
import org.apache.myfaces.test.mock.MockHttpServletResponse;
import org.apache.myfaces.test.mock.MockHttpSession;
import org.apache.myfaces.test.mock.MockRenderKit;
import org.apache.myfaces.test.mock.MockServletConfig;
import org.apache.myfaces.test.mock.MockServletContext;
import org.junit.After;
import org.junit.Before;

public abstract class AbstractJsfConfigurableMockTestCase {
    protected Application application = null;
    protected MockServletConfig config = null;
    protected ExternalContext externalContext = null;
    protected FacesContext facesContext = null;
    protected FacesContextFactory facesContextFactory = null;
    protected Lifecycle lifecycle = null;
    protected LifecycleFactory lifecycleFactory = null;
    protected RenderKit renderKit = null;
    protected MockHttpServletRequest request = null;
    protected MockHttpServletResponse response = null;
    protected MockServletContext servletContext = null;
    protected MockHttpSession session = null;
    private ClassLoader threadContextClassLoader = null;
    private boolean classLoaderSet = false;

    @Before
    public void setUp() throws Exception {
        this.setUpClassloader();
        this.setUpServletObjects();
        FactoryFinder.releaseFactories();
        this.setFactories();
        this.setUpJSFObjects();
    }

    protected void setUpClassloader() throws Exception {
        this.threadContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(new URLClassLoader(new URL[0], this.getClass().getClassLoader()));
        this.classLoaderSet = true;
    }

    protected void setUpJSFObjects() throws Exception {
        this.setUpExternalContext();
        this.setUpLifecycle();
        this.setUpFacesContext();
        this.setUpView();
        this.setUpApplication();
        this.setUpRenderKit();
    }

    protected void setUpServletObjects() throws Exception {
        this.servletContext = new MockServletContext();
        this.config = new MockServletConfig(this.servletContext);
        this.session = new MockHttpSession();
        this.session.setServletContext(this.servletContext);
        this.request = new MockHttpServletRequest(this.session);
        this.request.setServletContext(this.servletContext);
        this.response = new MockHttpServletResponse();
    }

    protected void setFactories() throws Exception {
        FactoryFinder.setFactory((String)"jakarta.faces.application.ApplicationFactory", (String)"org.apache.myfaces.test.mock.MockApplicationFactory");
        FactoryFinder.setFactory((String)"jakarta.faces.context.FacesContextFactory", (String)"org.apache.myfaces.test.mock.MockFacesContextFactory");
        FactoryFinder.setFactory((String)"jakarta.faces.lifecycle.LifecycleFactory", (String)"org.apache.myfaces.test.mock.lifecycle.MockLifecycleFactory");
        FactoryFinder.setFactory((String)"jakarta.faces.render.RenderKitFactory", (String)"org.apache.myfaces.test.mock.MockRenderKitFactory");
        FactoryFinder.setFactory((String)"jakarta.faces.context.ExceptionHandlerFactory", (String)"org.apache.myfaces.test.mock.MockExceptionHandlerFactory");
        FactoryFinder.setFactory((String)"jakarta.faces.context.PartialViewContextFactory", (String)"org.apache.myfaces.test.mock.MockPartialViewContextFactory");
        FactoryFinder.setFactory((String)"jakarta.faces.component.visit.VisitContextFactory", (String)"org.apache.myfaces.test.mock.visit.MockVisitContextFactory");
        FactoryFinder.setFactory((String)"jakarta.faces.lifecycle.ClientWindowFactory", (String)"org.apache.myfaces.test.mock.MockClientWindowFactory");
    }

    protected void setUpExternalContext() throws Exception {
        this.externalContext = new MockExternalContext(this.servletContext, this.request, this.response);
    }

    protected void setUpLifecycle() throws Exception {
        this.lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"jakarta.faces.lifecycle.LifecycleFactory");
        this.lifecycle = this.lifecycleFactory.getLifecycle("DEFAULT");
    }

    protected void setUpFacesContext() throws Exception {
        this.facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"jakarta.faces.context.FacesContextFactory");
        this.facesContext = this.facesContextFactory.getFacesContext((Object)this.servletContext, (Object)this.request, (Object)this.response, this.lifecycle);
        if (this.facesContext.getExternalContext() != null) {
            this.externalContext = this.facesContext.getExternalContext();
        }
    }

    protected void setUpView() throws Exception {
        UIViewRoot root = new UIViewRoot();
        root.setViewId("/viewId");
        root.setRenderKitId("HTML_BASIC");
        this.facesContext.setViewRoot(root);
    }

    protected void setUpApplication() throws Exception {
        ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"jakarta.faces.application.ApplicationFactory");
        this.application = applicationFactory.getApplication();
        ((MockFacesContext)this.facesContext).setApplication(this.application);
    }

    protected void setUpRenderKit() throws Exception {
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"jakarta.faces.render.RenderKitFactory");
        this.renderKit = new MockRenderKit();
        renderKitFactory.addRenderKit("HTML_BASIC", this.renderKit);
    }

    @After
    public void tearDown() throws Exception {
        this.application = null;
        this.config = null;
        this.externalContext = null;
        if (this.facesContext != null) {
            this.facesContext.release();
        }
        this.facesContext = null;
        this.lifecycle = null;
        this.lifecycleFactory = null;
        this.renderKit = null;
        this.request = null;
        this.response = null;
        this.servletContext = null;
        this.session = null;
        FactoryFinder.releaseFactories();
        ResourceBundleVarNames.resetNames();
        this.tearDownClassloader();
    }

    protected void tearDownClassloader() throws Exception {
        if (this.classLoaderSet) {
            Thread.currentThread().setContextClassLoader(this.threadContextClassLoader);
            this.threadContextClassLoader = null;
            this.classLoaderSet = false;
        }
    }
}

